package com.analysys.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;

/**
 * Create by Kevin on 2019-07-02
 * Describe:
 */
public class DeviceUtil {
    private static final String TAG = "DeviceUtil";
    public static final String HUAWEI = "$HUAWEI";
    public static final String OPPO = "$OPPO";
    public static final String VIVO = "$VIVO";
    public static final String MEIZU = "$MEIZU";

    public static boolean isXiaomiDevice() {
        if (Build.MANUFACTURER.equalsIgnoreCase("xiaomi")) {
            return true;
        }
        return false;
    }

    public static boolean isHuaweiDevice() {
        if (Build.MANUFACTURER.equalsIgnoreCase("huawei")) {
            return true;
        }
        return false;
    }

    public static boolean isOppoDevice() {
        if (Build.MANUFACTURER.equalsIgnoreCase("oppo")) {
            return true;
        }
        return false;
    }

    public static boolean isVivoDevice() {
        if (Build.MANUFACTURER.equalsIgnoreCase("vivo")) {
            return true;
        }
        return false;
    }

    public static boolean isMeizuDevice() {
        if (Build.MANUFACTURER.equalsIgnoreCase("meizu")) {
            return true;
        }
        return false;
    }

    /**
     * 获取手机IMEI(需要“android.permission.READ_PHONE_STATE”权限)
     *
     * @return 手机IMEI
     */
    @SuppressLint("MissingPermission")
    public static String getIMEI(Context ctx) {
        TelephonyManager tm = (TelephonyManager) ctx.getSystemService(Activity.TELEPHONY_SERVICE);
        try {
            return tm.getDeviceId();
        } catch (Exception e) {
            Log.e(TAG, "getIMEI", e);
            return null;
        }
    }
}
