/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.Database;
import cn.codeforfun.migrate.core.entity.structure.Routine;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Procedure
implements Serializable,
Difference {
    private static final long serialVersionUID = -7316847891519066690L;
    private String securityType;
    private String definer;
    private String schema;
    private String name;
    private String source;
    private Database database;
    private List<Routine> routines = new ArrayList<Routine>();

    public static List<Procedure> configure(Connection connection, Database database) throws SQLException {
        List<Routine> beanList = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/procedure.sql"), Routine.class, database.getInfo().getName());
        HashMap<String, Procedure> procedures = new HashMap<String, Procedure>(0);
        for (Routine routine : beanList) {
            Procedure procedure = (Procedure)procedures.get(routine.getName());
            if (procedure == null) {
                procedure = new Procedure();
            }
            procedure.setDatabase(database);
            procedure.getRoutines().add(routine);
            procedure.setDefiner(routine.getDefiner());
            procedure.setSecurityType(routine.getSecurityType());
            procedure.setSchema(routine.getSchema());
            procedure.setName(routine.getName());
            procedure.setSource(routine.getSource());
            procedures.put(routine.getName(), procedure);
        }
        return new ArrayList<Procedure>(procedures.values());
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE PROCEDURE `").append(this.name).append("`");
        sb.append("(");
        List inputTypeList = this.getRoutines().stream().filter(s -> "IN".equals(s.getParamMode())).collect(Collectors.toList());
        List resultTypeList = this.getRoutines().stream().filter(s -> "OUT".equals(s.getParamMode())).collect(Collectors.toList());
        for (Routine inList : inputTypeList) {
            sb.append("IN ").append(inList.getParamName()).append(" ").append(inList.getResultType()).append(",");
        }
        for (Routine outList : resultTypeList) {
            sb.append("OUT ").append(outList.getParamName()).append(" ").append(outList.getResultType()).append(",");
        }
        if (inputTypeList.size() > 0 || resultTypeList.size() > 0) {
            sb = new StringBuilder(sb.substring(0, sb.length() - 1));
        }
        sb.append(") ");
        sb.append(" ").append(this.source).append(";");
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "DROP PROCEDURE `" + this.name + "`;";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Procedure)) {
            return false;
        }
        Procedure procedure = (Procedure)o;
        return Objects.equals(this.getName(), procedure.getName()) && Objects.equals(this.getSource(), procedure.getSource()) && Objects.equals(this.getRoutines(), procedure.getRoutines());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getSource(), this.getRoutines());
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getDefiner() {
        return this.definer;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getSource() {
        return this.source;
    }

    public Database getDatabase() {
        return this.database;
    }

    public List<Routine> getRoutines() {
        return this.routines;
    }

    public void setSecurityType(String securityType) {
        this.securityType = securityType;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public void setRoutines(List<Routine> routines) {
        this.routines = routines;
    }
}

