/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity;

import cn.codeforfun.migrate.core.utils.ObjectUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.TimeZone;

public class DatabaseInfo
implements Serializable {
    private static final long serialVersionUID = -4275505729761182481L;
    private String host;
    private Integer port;
    private String username;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private String password;
    private String name;
    private String url;
    private Boolean ignoreCharacterCompare = false;

    public DatabaseInfo(String host, Integer port, String username, String password, String name) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.name = name;
        this.url = this.getUrl();
    }

    public String getUrl() {
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.name;
        url = url + "?useUnicode=true&characterEncoding=utf8&createDatabaseIfNotExist=true";
        String timeZone = TimeZone.getDefault().getID();
        if (!ObjectUtils.isEmpty(timeZone)) {
            url = url + "&serverTimezone=" + timeZone;
        }
        return url;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIgnoreCharacterCompare() {
        return this.ignoreCharacterCompare;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    public void setPassword(String password) {
        this.password = password;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setIgnoreCharacterCompare(Boolean ignoreCharacterCompare) {
        this.ignoreCharacterCompare = ignoreCharacterCompare;
    }

    public DatabaseInfo() {
    }

    public DatabaseInfo(String host, Integer port, String username, String password, String name, String url, Boolean ignoreCharacterCompare) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.name = name;
        this.url = url;
        this.ignoreCharacterCompare = ignoreCharacterCompare;
    }
}

