/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.utils;

import cn.codeforfun.migrate.core.exception.DatabaseConnectException;
import cn.codeforfun.migrate.core.utils.MigrateBeanTools;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.BeanListHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtil {
    private static final Logger log = LoggerFactory.getLogger(DbUtil.class);

    public static <T> List<T> getBeanList(Connection connection, String sql, Class<T> clazz) throws SQLException {
        QueryRunner runner = new QueryRunner();
        return (List)runner.query(connection, sql, (ResultSetHandler)new BeanListHandler(clazz, (RowProcessor)new BasicRowProcessor(new BeanProcessor(MigrateBeanTools.customColumn(clazz)))));
    }

    public static <T> List<T> getBeanList(Connection connection, String sql, Class<T> clazz, Object ... params) throws SQLException {
        QueryRunner runner = new QueryRunner();
        return (List)runner.query(connection, sql, (ResultSetHandler)new BeanListHandler(clazz, (RowProcessor)new BasicRowProcessor(new BeanProcessor(MigrateBeanTools.customColumn(clazz)))), params);
    }

    public static <T> T getBean(Connection connection, String sql, Class<T> clazz) throws SQLException {
        QueryRunner runner = new QueryRunner();
        return (T)runner.query(connection, sql, (ResultSetHandler)new BeanHandler(clazz, (RowProcessor)new BasicRowProcessor(new BeanProcessor(MigrateBeanTools.customColumn(clazz)))));
    }

    public static <T> T getBean(Connection connection, String sql, Class<T> clazz, Object ... params) throws SQLException {
        QueryRunner runner = new QueryRunner();
        return (T)runner.query(connection, sql, (ResultSetHandler)new BeanHandler(clazz, (RowProcessor)new BasicRowProcessor(new BeanProcessor(MigrateBeanTools.customColumn(clazz)))), params);
    }

    public static Connection getConnection(String url, String username, String password) {
        Connection connection;
        try {
            connection = DriverManager.getConnection(url, username, password);
        }
        catch (Exception e) {
            log.error("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25,url:{},user:{}", (Object)url, (Object)username);
            throw new DatabaseConnectException("\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25");
        }
        return connection;
    }

    public static void execute(Connection connection, String sql) throws SQLException {
        QueryRunner runner = new QueryRunner();
        runner.update(connection, sql);
    }
}

