/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;

public class Trigger
implements Serializable,
Difference {
    private static final long serialVersionUID = 8820673590063935538L;
    @DbUtilProperty(value="TRIGGER_SCHEMA")
    private String schema;
    @DbUtilProperty(value="TRIGGER_NAME")
    private String name;
    @DbUtilProperty(value="DEFINER")
    private String definer;
    @DbUtilProperty(value="ACTION_TIMING")
    private String actionTiming;
    @DbUtilProperty(value="EVENT_MANIPULATION")
    private String eventManipulation;
    @DbUtilProperty(value="EVENT_OBJECT_SCHEMA")
    private String objectSchema;
    @DbUtilProperty(value="EVENT_OBJECT_TABLE")
    private String objectTable;
    @DbUtilProperty(value="ACTION_ORIENTATION")
    private String actionOrientation;
    @DbUtilProperty(value="ACTION_STATEMENT")
    private String source;

    public static List<Trigger> configure(Connection connection, String databaseName) throws SQLException {
        return DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/trigger.sql"), Trigger.class, databaseName);
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        String[] split = this.definer.split("@");
        return "CREATE DEFINER =`" + split[0] + "`@`" + split[1] + "` TRIGGER " + this.name + " " + this.actionTiming + " " + this.eventManipulation + " ON `" + this.objectTable + "` FOR EACH " + this.actionOrientation + " " + this.source + ";";
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "DROP TRIGGER `" + this.name + "`;";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Trigger)) {
            return false;
        }
        Trigger trigger = (Trigger)o;
        return Objects.equals(this.getSchema(), trigger.getSchema()) && Objects.equals(this.getName(), trigger.getName()) && Objects.equals(this.getDefiner(), trigger.getDefiner()) && Objects.equals(this.getActionTiming(), trigger.getActionTiming()) && Objects.equals(this.getEventManipulation(), trigger.getEventManipulation()) && Objects.equals(this.getObjectSchema(), trigger.getObjectSchema()) && Objects.equals(this.getObjectTable(), trigger.getObjectTable()) && Objects.equals(this.getActionOrientation(), trigger.getActionOrientation()) && Objects.equals(this.getSource(), trigger.getSource());
    }

    public int hashCode() {
        return Objects.hash(this.getSchema(), this.getName(), this.getDefiner(), this.getActionTiming(), this.getEventManipulation(), this.getObjectSchema(), this.getObjectTable(), this.getActionOrientation(), this.getSource());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getDefiner() {
        return this.definer;
    }

    public String getActionTiming() {
        return this.actionTiming;
    }

    public String getEventManipulation() {
        return this.eventManipulation;
    }

    public String getObjectSchema() {
        return this.objectSchema;
    }

    public String getObjectTable() {
        return this.objectTable;
    }

    public String getActionOrientation() {
        return this.actionOrientation;
    }

    public String getSource() {
        return this.source;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDefiner(String definer) {
        this.definer = definer;
    }

    public void setActionTiming(String actionTiming) {
        this.actionTiming = actionTiming;
    }

    public void setEventManipulation(String eventManipulation) {
        this.eventManipulation = eventManipulation;
    }

    public void setObjectSchema(String objectSchema) {
        this.objectSchema = objectSchema;
    }

    public void setObjectTable(String objectTable) {
        this.objectTable = objectTable;
    }

    public void setActionOrientation(String actionOrientation) {
        this.actionOrientation = actionOrientation;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

