/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity.structure;

import cn.codeforfun.migrate.core.diff.Difference;
import cn.codeforfun.migrate.core.entity.structure.Column;
import cn.codeforfun.migrate.core.entity.structure.Key;
import cn.codeforfun.migrate.core.entity.structure.annotations.DbUtilProperty;
import cn.codeforfun.migrate.core.utils.DbUtil;
import cn.codeforfun.migrate.core.utils.FileUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.ObjectUtils;

public class Table
implements Serializable,
Difference {
    private static final long serialVersionUID = 411108952654575238L;
    @DbUtilProperty(value="TABLE_SCHEMA")
    private String schema;
    @DbUtilProperty(value="TABLE_NAME")
    private String name;
    @DbUtilProperty(value="TABLE_TYPE")
    private String type;
    @DbUtilProperty(value="ENGINE")
    private String engine;
    @DbUtilProperty(value="CREATE_TIME")
    private Date createTime;
    @DbUtilProperty(value="UPDATE_TIME")
    private Date updateTime;
    @DbUtilProperty(value="CHARACTER_SET_NAME")
    private String charset;
    @DbUtilProperty(value="TABLE_COLLATION")
    private String collate;
    @DbUtilProperty(value="TABLE_COMMENT")
    private String comment;
    private List<Column> columns;
    private List<Key> keys;
    public static final String SQL = FileUtil.getStringByClasspath("sql/diff/create-table.sql");

    public boolean hasForeignKey() {
        for (Key key : this.keys) {
            if ("PRIMARY".equals(key.getName()) || ObjectUtils.isEmpty((Object)key.getReferencedSchema()) || ObjectUtils.isEmpty((Object)key.getReferencedTable()) || ObjectUtils.isEmpty((Object)key.getReferencedColumn())) continue;
            return true;
        }
        return false;
    }

    @JsonIgnore
    public String getDeleteForeignKeySql() {
        StringBuilder sb = new StringBuilder();
        for (Key key : this.keys) {
            if ("PRIMARY".equals(key.getName()) || ObjectUtils.isEmpty((Object)key.getReferencedSchema()) || ObjectUtils.isEmpty((Object)key.getReferencedTable()) || ObjectUtils.isEmpty((Object)key.getReferencedColumn())) continue;
            sb.append("ALTER TABLE `").append(key.getTableName()).append("` DROP FOREIGN KEY `").append(key.getName()).append("`;");
        }
        return sb.toString();
    }

    @Override
    @JsonIgnore
    public String getUpdateSql() {
        return null;
    }

    @Override
    @JsonIgnore
    public String getDeleteSql() {
        return "DROP TABLE `" + this.name + "`;";
    }

    @Override
    @JsonIgnore
    public String getCreateSql() {
        String sql = SQL;
        sql = sql.replace("${tableName}", this.name);
        sql = sql.replace("${engine}", " ENGINE = " + this.engine);
        sql = sql.replace("${charset}", " DEFAULT CHARSET = " + this.charset);
        sql = sql.replace("${collate}", " COLLATE = " + this.collate);
        sql = sql.replace("${comment}", ObjectUtils.isEmpty((Object)this.comment) ? "" : " COMMENT = '" + this.comment + "'");
        StringBuilder sb = new StringBuilder();
        for (Column column : this.columns) {
            String columnSql = column.getCreateTableSql();
            sb.append(columnSql);
        }
        for (Key key : this.keys) {
            String keySql = key.getCreateTableSql();
            sb.append(keySql);
        }
        String columnSql = sb.substring(0, sb.length() - 1);
        sql = sql.replace("${columnSql}", columnSql);
        return sql;
    }

    public static List<Table> configure(Connection connection, String databaseName) throws SQLException {
        List<Table> list1 = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/table.sql"), Table.class, databaseName);
        List<Column> list2 = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/column.sql"), Column.class, databaseName);
        List<Key> list3 = DbUtil.getBeanList(connection, FileUtil.getStringByClasspath("sql/detail/key.sql"), Key.class, databaseName);
        return list1.stream().peek(o -> {
            o.setColumns(list2.stream().filter(s -> o.getName().equals(s.getTable())).collect(Collectors.toList()));
            o.setKeys(list3.stream().filter(s -> o.getName().equals(s.getTableName())).collect(Collectors.toList()));
        }).collect(Collectors.toList());
    }

    public String getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getEngine() {
        return this.engine;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getCollate() {
        return this.collate;
    }

    public String getComment() {
        return this.comment;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<Key> getKeys() {
        return this.keys;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCollate(String collate) {
        this.collate = collate;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setKeys(List<Key> keys) {
        this.keys = keys;
    }
}

