/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.TimeZone;
import org.springframework.util.ObjectUtils;

public class DatabaseInfo
implements Serializable {
    private static final long serialVersionUID = -4275505729761182481L;
    private String host;
    private Integer port;
    private String name;
    private String username;
    @JsonIgnore
    private String password;
    private String url;

    public DatabaseInfo(String host, Integer port, String name, String username, String password) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.username = username;
        this.password = password;
        this.url = this.getUrl();
    }

    public String getUrl() {
        String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.name;
        url = url + "?useUnicode=true&characterEncoding=utf8&createDatabaseIfNotExist=true";
        String timeZone = TimeZone.getDefault().getID();
        if (!ObjectUtils.isEmpty((Object)timeZone)) {
            url = url + "&serverTimezone=" + timeZone;
        }
        return url;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DatabaseInfo() {
    }

    public DatabaseInfo(String host, Integer port, String name, String username, String password, String url) {
        this.host = host;
        this.port = port;
        this.name = name;
        this.username = username;
        this.password = password;
        this.url = url;
    }
}

