/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.migrate.core;

import cn.codeforfun.migrate.core.diff.DiffResult;
import cn.codeforfun.migrate.core.entity.DatabaseInfo;
import cn.codeforfun.migrate.core.entity.structure.Column;
import cn.codeforfun.migrate.core.entity.structure.Database;
import cn.codeforfun.migrate.core.entity.structure.Function;
import cn.codeforfun.migrate.core.entity.structure.Key;
import cn.codeforfun.migrate.core.entity.structure.Procedure;
import cn.codeforfun.migrate.core.entity.structure.Table;
import cn.codeforfun.migrate.core.entity.structure.Trigger;
import cn.codeforfun.migrate.core.entity.structure.View;
import cn.codeforfun.migrate.core.utils.DbUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class Migrate {
    private static final Logger log = LoggerFactory.getLogger(Migrate.class);
    private DatabaseInfo sourceInfo;
    private DatabaseInfo targetInfo;
    private DiffResult diff;

    public Migrate(DatabaseInfo targetInfo) {
        this.targetInfo = targetInfo;
    }

    public Migrate(DatabaseInfo sourceInfo, DatabaseInfo targetInfo) {
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
    }

    public Migrate from(DatabaseInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
        return this;
    }

    public Migrate to(DatabaseInfo targetInfo) {
        this.targetInfo = targetInfo;
        return this;
    }

    private void compare() {
        List<Table> fromTableList = this.diff.getFrom().getTables();
        List<Table> toTableList = this.diff.getTo().getTables();
        List<String> fromTableNameList = fromTableList.stream().map(Table::getName).collect(Collectors.toList());
        List<String> toTableNameList = toTableList.stream().map(Table::getName).collect(Collectors.toList());
        List<Table> fromUpdateTableList = fromTableList.stream().filter(s -> toTableNameList.contains(s.getName())).collect(Collectors.toList());
        List<Table> toUpdateTableList = toTableList.stream().filter(s -> fromTableNameList.contains(s.getName())).collect(Collectors.toList());
        this.compareKey(fromUpdateTableList, toUpdateTableList);
        this.compareColumn(fromUpdateTableList, toUpdateTableList);
        this.compareTable(fromTableList, toTableList, fromTableNameList, toTableNameList);
        this.compareView();
        this.compareFunction();
        this.compareProcedure();
        this.compareTrigger();
    }

    private void compareTrigger() {
        List<Trigger> fromTriggerList = this.diff.getFrom().getTriggers();
        List<Trigger> toTriggerList = this.diff.getTo().getTriggers();
        List fromTriggerNameList = fromTriggerList.stream().map(Trigger::getName).collect(Collectors.toList());
        List toTriggerNameList = toTriggerList.stream().map(Trigger::getName).collect(Collectors.toList());
        List deleteTriggerList = toTriggerList.stream().filter(s -> !fromTriggerNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteTriggerList);
        List createTriggerList = fromTriggerList.stream().filter(s -> !toTriggerNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createTriggerList);
        List updateTriggerList = toTriggerList.stream().map(s -> fromTriggerList.stream().filter(j -> s.getName().equals(j.getName()) && s.getSchema().equals(j.getSchema()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateTriggerList);
    }

    private void compareProcedure() {
        List<Procedure> fromProcedureList = this.diff.getFrom().getProcedures();
        List<Procedure> toProcedureList = this.diff.getTo().getProcedures();
        List fromProcedureNameList = fromProcedureList.stream().map(Procedure::getName).collect(Collectors.toList());
        List toProcedureNameList = toProcedureList.stream().map(Procedure::getName).collect(Collectors.toList());
        List deleteProcedureList = toProcedureList.stream().filter(s -> !fromProcedureNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteProcedureList);
        List createProcedureList = fromProcedureList.stream().filter(s -> !toProcedureNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createProcedureList);
        List updateProcedureList = toProcedureList.stream().map(s -> fromProcedureList.stream().filter(j -> s.getName().equals(j.getName()) && s.getSchema().equals(j.getSchema()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateProcedureList);
    }

    private void compareFunction() {
        List<Function> fromFunctionList = this.diff.getFrom().getFunctions();
        List<Function> toFunctionList = this.diff.getTo().getFunctions();
        List fromFunctionNameList = fromFunctionList.stream().map(Function::getName).collect(Collectors.toList());
        List toFunctionNameList = toFunctionList.stream().map(Function::getName).collect(Collectors.toList());
        List deleteFunctionList = toFunctionList.stream().filter(s -> !fromFunctionNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteFunctionList);
        List createFunctionList = fromFunctionList.stream().filter(s -> !toFunctionNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createFunctionList);
        List updateFunctionList = toFunctionList.stream().map(s -> fromFunctionList.stream().filter(j -> s.getName().equals(j.getName()) && s.getSchema().equals(j.getSchema()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateFunctionList);
    }

    private void compareView() {
        List<View> fromViewList = this.diff.getFrom().getViews();
        List<View> toViewList = this.diff.getTo().getViews();
        List fromViewNameList = fromViewList.stream().map(View::getName).collect(Collectors.toList());
        List toViewNameList = toViewList.stream().map(View::getName).collect(Collectors.toList());
        List deleteViewList = toViewList.stream().filter(s -> !fromViewNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteViewList);
        List createViewList = fromViewList.stream().filter(s -> !toViewNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createViewList);
        List updateViewList = toViewList.stream().map(s -> fromViewList.stream().filter(j -> s.getName().equals(j.getName()) && s.getSchema().equals(j.getSchema()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateViewList);
    }

    private void compareColumn(List<Table> fromUpdateTableList, List<Table> toUpdateTableList) {
        List fromColumnList = fromUpdateTableList.stream().map(Table::getColumns).flatMap(Collection::stream).collect(Collectors.toList());
        List toColumnList = toUpdateTableList.stream().map(Table::getColumns).flatMap(Collection::stream).collect(Collectors.toList());
        List fromColumnNameList = fromColumnList.stream().map(Column::getName).collect(Collectors.toList());
        List toColumnNameList = toColumnList.stream().map(Column::getName).collect(Collectors.toList());
        List deleteColumnList = toColumnList.stream().filter(s -> !fromColumnNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteColumnList);
        List createColumnList = fromColumnList.stream().filter(s -> !toColumnNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createColumnList);
        List updateColumnList = toColumnList.stream().map(s -> fromColumnList.stream().filter(j -> s.getName().equals(j.getName()) && s.getSchema().equals(j.getSchema()) && s.getTable().equals(j.getTable()) && !s.equals(j)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        this.diff.getUpdate().addAll(updateColumnList);
    }

    private void compareKey(List<Table> fromUpdateTableList, List<Table> toUpdateTableList) {
        List fromKeyList = fromUpdateTableList.stream().map(Table::getKeys).flatMap(Collection::stream).collect(Collectors.toList());
        List toKeyList = toUpdateTableList.stream().map(Table::getKeys).flatMap(Collection::stream).collect(Collectors.toList());
        List fromKeyNameList = fromKeyList.stream().map(Key::getName).collect(Collectors.toList());
        List toKeyNameList = toKeyList.stream().map(Key::getName).collect(Collectors.toList());
        List deleteKeyList = toKeyList.stream().filter(s -> !fromKeyNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteKeyList);
        List createKeyList = fromKeyList.stream().filter(s -> !toKeyNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createKeyList);
        ArrayList<Key> updateKeyList = new ArrayList<Key>();
        for (Key fromKey : fromKeyList) {
            for (Key toKey : toKeyList) {
                if (!fromKey.getSchema().equals(toKey.getSchema()) || !fromKey.getName().equals(toKey.getName()) || !fromKey.getTableName().equals(toKey.getTableName()) || fromKey.equals(toKey)) continue;
                updateKeyList.add(fromKey);
            }
        }
        this.diff.getUpdate().addAll(updateKeyList);
    }

    private void compareTable(List<Table> fromTableList, List<Table> toTableList, List<String> fromTableNameList, List<String> toTableNameList) {
        List deleteTableList = toTableList.stream().filter(s -> !fromTableNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getDelete().addAll(deleteTableList);
        List createTableList = fromTableList.stream().filter(s -> !toTableNameList.contains(s.getName())).collect(Collectors.toList());
        this.diff.getCreate().addAll(createTableList);
    }

    public DiffResult diff() throws SQLException {
        if (this.sourceInfo == null) {
            log.error("sourceDatabase \u4e3a\u7a7a");
            throw new NullPointerException("sourceDatabase \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.targetInfo == null) {
            log.error("targetDatabase \u4e3a\u7a7a");
            throw new NullPointerException("targetDatabase \u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.debug("\u5f00\u59cb\u5bf9\u6bd4\u6570\u636e\u5e93");
        Database source = new Database().init(this.sourceInfo);
        Database target = new Database().init(this.targetInfo);
        this.diff = new DiffResult(source, target);
        this.compare();
        log.debug("\u5bf9\u6bd4\u6570\u636e\u5e93\u5b8c\u6210");
        if (ObjectUtils.isEmpty(this.diff.getDelete()) && ObjectUtils.isEmpty(this.diff.getCreate()) && ObjectUtils.isEmpty(this.diff.getUpdate())) {
            log.debug("\u6570\u636e\u5e93\u7ed3\u6784\u6ca1\u6709\u53d8\u5316\u3002");
        }
        return this.diff;
    }

    public void update() throws SQLException {
        if (this.diff == null) {
            this.diff();
        }
        if (ObjectUtils.isEmpty(this.diff.getDelete()) && ObjectUtils.isEmpty(this.diff.getCreate()) && ObjectUtils.isEmpty(this.diff.getUpdate())) {
            return;
        }
        log.debug("\u5f00\u59cb\u540c\u6b65\u6570\u636e\u5e93");
        List<String> sqlList = this.diff.getSqlList();
        for (String sql : sqlList) {
            DbUtil.execute(this.diff.getTo().getConnection(), sql);
        }
        log.debug("\u6570\u636e\u5e93\u540c\u6b65\u5b8c\u6210");
    }

    public DatabaseInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public DatabaseInfo getTargetInfo() {
        return this.targetInfo;
    }

    public DiffResult getDiff() {
        return this.diff;
    }

    public void setSourceInfo(DatabaseInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setTargetInfo(DatabaseInfo targetInfo) {
        this.targetInfo = targetInfo;
    }

    public void setDiff(DiffResult diff) {
        this.diff = diff;
    }

    public Migrate() {
    }
}

