/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.client.configuration;

import cn.codeforfun.client.constants.DiscoveryServiceProperties;
import cn.codeforfun.client.data.DataContext;
import cn.codeforfun.client.data.DataContextReactive;
import cn.codeforfun.client.data.DataHandler;
import cn.codeforfun.client.data.ServiceInstance;
import cn.codeforfun.client.exception.ServiceNameNotFoundException;
import cn.hutool.core.net.NetUtil;
import cn.hutool.cron.CronUtil;
import java.util.List;
import java.util.Objects;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.util.ObjectUtils;

@Configuration
@Import(value={DiscoveryServiceProperties.class})
public class DiscoveryServiceAutoConfiguration
implements ApplicationListener<WebServerInitializedEvent> {
    @Resource
    private Environment environment;
    @Resource
    private DataHandler dataHandler;
    @Resource
    private DataContext dataContext;
    @Resource
    private DataContextReactive dataContextReactive;
    @Resource
    private DiscoveryServiceProperties discoveryServiceProperties;
    WebServerInitializedEvent event;

    public void onApplicationEvent(WebServerInitializedEvent event) {
        this.event = event;
        this.registerCurrentService();
        this.startActiveCurrentServiceSchedule();
        this.startRefreshServiceListSchedule();
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start();
    }

    @PreDestroy
    public void stop() {
        CronUtil.stop();
        this.deregisterCurrentService();
    }

    private void deregisterCurrentService() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        this.dataHandler.deregisterService(serviceInstance);
    }

    private void startRefreshServiceListSchedule() {
        Integer refreshServiceListInterval = this.discoveryServiceProperties.getRefreshServiceListInterval();
        String cron = "*/" + refreshServiceListInterval + " * * * * *";
        Integer serviceActiveTimeout = this.discoveryServiceProperties.getServiceActiveTimeout();
        CronUtil.schedule((String)cron, () -> this.refreshServiceInstanceList(serviceActiveTimeout));
    }

    private void refreshServiceInstanceList(Integer serviceActiveTimeout) {
        List<ServiceInstance> serviceInstanceList = this.dataHandler.findServiceInstanceList(serviceActiveTimeout);
        if (!ObjectUtils.isEmpty(serviceInstanceList)) {
            this.dataContext.refreshServiceInstances(serviceInstanceList);
            this.dataContextReactive.refreshServiceInstances(serviceInstanceList);
        }
    }

    private void startActiveCurrentServiceSchedule() {
        Integer serviceActiveInterval = this.discoveryServiceProperties.getServiceActiveInterval();
        String cron = "*/" + serviceActiveInterval + " * * * * *";
        CronUtil.schedule((String)cron, this::activeCurrentService);
    }

    private void activeCurrentService() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        this.dataHandler.activeService(serviceInstance);
    }

    private void registerCurrentService() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        this.dataHandler.registerService(serviceInstance);
    }

    private ServiceInstance getServiceInstance() {
        ServiceInstance serviceInstance = new ServiceInstance();
        serviceInstance.setName(this.getApplicationName());
        serviceInstance.setHost(this.getHost());
        serviceInstance.setPort(this.getPort());
        return serviceInstance;
    }

    private String getHost() {
        String host = this.discoveryServiceProperties.getHost() != null ? this.discoveryServiceProperties.getHost() : NetUtil.getLocalhostStr();
        return host;
    }

    private Integer getPort() {
        Integer port = this.discoveryServiceProperties.getPort() != null ? this.discoveryServiceProperties.getPort() : (this.environment.getProperty("server.port") != null && !"0".equals(this.environment.getProperty("server.port")) ? Integer.valueOf(Objects.requireNonNull(this.environment.getProperty("server.port"))) : Integer.valueOf(this.event.getWebServer().getPort()));
        return port;
    }

    private String getApplicationName() {
        String applicationName;
        if (this.discoveryServiceProperties.getName() != null) {
            applicationName = this.discoveryServiceProperties.getName();
        } else if (this.environment.getProperty("spring.application.name") != null) {
            applicationName = this.environment.getProperty("spring.application.name");
        } else {
            throw new ServiceNameNotFoundException("Service name not found, you must set discovery.service.name or spring.application.name first.");
        }
        return applicationName;
    }
}

