/*
 * Decompiled with CFR 0.152.
 */
package cn.codeforfun.client.data;

import cn.codeforfun.client.constants.DiscoveryServiceProperties;
import cn.codeforfun.client.data.DataHandler;
import cn.codeforfun.client.data.ServiceInstance;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DataContext
implements DiscoveryClient {
    private Map<String, List<ServiceInstance>> instances = new HashMap<String, List<ServiceInstance>>();
    @Resource
    DataHandler dataHandler;
    @Resource
    DiscoveryServiceProperties discoveryServiceProperties;

    public String description() {
        return null;
    }

    public List<org.springframework.cloud.client.ServiceInstance> getInstances(String serviceId) {
        List<ServiceInstance> serviceInstances = this.instances.get(serviceId);
        if (ObjectUtils.isEmpty(serviceInstances)) {
            this.refreshServiceInstances();
            serviceInstances = this.instances.get(serviceId);
        }
        if (ObjectUtils.isEmpty(serviceInstances)) {
            return new ArrayList<org.springframework.cloud.client.ServiceInstance>();
        }
        return serviceInstances.stream().map(s -> new org.springframework.cloud.client.ServiceInstance((ServiceInstance)s){
            final /* synthetic */ ServiceInstance val$s;
            {
                this.val$s = serviceInstance;
            }

            public String getServiceId() {
                return this.val$s.getName();
            }

            public String getHost() {
                return this.val$s.getHost();
            }

            public int getPort() {
                return this.val$s.getPort();
            }

            public boolean isSecure() {
                return false;
            }

            public URI getUri() {
                return URI.create("http://" + this.val$s.getHost() + ":" + this.val$s.getPort());
            }

            public Map<String, String> getMetadata() {
                return new HashMap<String, String>();
            }
        }).collect(Collectors.toList());
    }

    public List<String> getServices() {
        return new ArrayList<String>(this.instances.keySet());
    }

    private void refreshServiceInstances() {
        Integer serviceActiveTimeout = this.discoveryServiceProperties.getServiceActiveTimeout();
        List<ServiceInstance> serviceInstanceList = this.dataHandler.findServiceInstanceList(serviceActiveTimeout);
        this.refreshServiceInstances(serviceInstanceList);
    }

    public void refreshServiceInstances(List<ServiceInstance> serviceInstanceList) {
        this.instances = serviceInstanceList.stream().collect(Collectors.groupingBy(ServiceInstance::getName));
    }
}

