package cn.tom.rpc.service;


import java.io.IOException;

import cn.tom.rpc.ClientPool;
import cn.tom.rpc.RpcClient;
import cn.tom.rpc.RpcMessage;
import cn.tom.transport.Messager.MessageCallback;
import cn.tom.transport.Messager.MessageHandler;

public class ServiceGroup {
	
	ClientPool clientPool;
	
	public ServiceGroup(String address, int clientPoolSize) {
		clientPool = new ClientPool(address, clientPoolSize, true);
	}
	
	public void registerHandler(String cmd, MessageHandler<RpcMessage> handler){
		for(RpcClient client: clientPool.getObjects()){
			client.registerHandler(cmd, handler);
		}
	}
	
	public void delcare(String topic) throws IOException{
		for(RpcClient client: clientPool.getObjects()){
			client.delcare(topic, new MessageCallback<RpcMessage>() {

				@Override
				public void onReturn(RpcMessage result) {
					System.out.println(result);
				}
			} );
		}
		
	}
	
	

}
