package cn.tom.rpc.service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

import cn.tom.kit.Multimap;
import cn.tom.rpc.RpcMessage;
import cn.tom.transport.Session;
import cn.tom.transport.Messager.MessageHandler;

public class RpcProcessor implements MessageHandler<RpcMessage> {

	private ModuleInvoker moduleInvoker;
	private ServiceGroup service;

	public RpcProcessor(String packageName, ServiceGroup service) throws Exception {
		this.moduleInvoker = new ModuleInvoker(packageName);
		this.service = service;
	}

	public RpcProcessor(ModuleInvoker moduleInvoker) {
		this.moduleInvoker = moduleInvoker;
	}

	public void declare(String topic) throws IOException {
		service.delcare(topic);
		service.registerHandler(topic, this);
	}

	@Override
	public void handleMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {
		RpcMessage res = process(msg);
		res.getHeader().setAsk((byte) 1);
		res.setCustom();
		res.getHeader().setCompress((byte) 1);
		sess.write(res);
	}

	private RpcMessage process(RpcMessage msg) {
		String module = msg.getModule();
		long a = System.currentTimeMillis();
		// 直接body 内容为json字符串
		Map<String, Object> params = msg.getParam();
		Object respBody = null;
		if (params.size() == 0) {
			respBody = moduleInvoker.invoke(module);
		} else if (params.get("^") != null) {
			Object obj[] = new Object[params.size()];
			obj[0] = params.get("^");
			for (int i = 1; i < obj.length; i++) {
				obj[i] = params.get("p" + i);
			}
			respBody = moduleInvoker.invoke(module, obj);
		} else {
			respBody = moduleInvoker.invoke(module, params);
		}
		
		parseReturnType(msg, respBody);
		return msg;
	}

	@SuppressWarnings("unchecked")
	private void parseReturnType(RpcMessage msg, Object respBody) {
		msg.params.clear();
		if (respBody instanceof Map) {
			msg.setParam((Map<String,Object>) respBody);
		} else if (respBody instanceof List) {
			msg.setParams((List<Map<String, Object>>) respBody);
		} else {
			msg.setParam(Multimap.createMap("^", respBody));
		}
	}

}
