package cn.tom.rpc.service;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import cn.tom.kit.Multimap;
import cn.tom.kit.Scan;


/**
 * 记录 了所有的 调用的 module[method] 和 service[class实例]
 * @author tomsun
 */

public class ModuleInvoker {
	
	private static final HashMap<String, ServiceHandler> services = new HashMap<String, ServiceHandler>();
	
	public ModuleInvoker() {
	}
	
	public ModuleInvoker(String packageName) throws Exception {
		scanpackage(packageName);
	}
	
	protected Object invoke(String module, Object... params) {
		Multimap<String, String> error =  Multimap.createMap("state", "500");
		try {
			String m[] = module.split("\\.");
			ModuleInvoker.ServiceHandler handler = services.get(m[0]);
			if (handler == null) {
				return error.set("msg", "service:[" + m[0] + "] is null");
			}
			Method meth = handler.getMethod(m[1]);
			if (meth == null) {
				return error.set("msg", "method:[" + m[1] + "] is null");
			}
			
			Object obj = meth.invoke(handler.getService(), params);
			return obj;
		} catch (Exception e) {
			e.printStackTrace();
			return  error.set("msg", e.getMessage());
		}
	};

	
	/**
	 * 包扫描 
	 * @param _packagename
	 * @throws Exception
	 */
	public void scanpackage(String packageName) throws Exception {
		Set<Class<?>> set = Scan.scanpackage(packageName);
		for(Class<?> clazz : set){
			if(RpcBase.class.isAssignableFrom(clazz) && RpcBase.class!=clazz){ //继承 RpcBase 标识接口
				ServiceHandler handler = new ServiceHandler(clazz);
				services.put(clazz.getSimpleName(), handler);
				for(String name :getAllInterfaces(clazz)){
					services.put(name, handler);
				} 
			}
		}
		System.out.println("scanService::"+services);
	}
	
	public static <T> T getService(Class<T> clazz){
		return clazz.cast(services.get(clazz.getSimpleName()).getService());
	}
	
	
	private static List<String> getAllInterfaces(Class<?> clazz){
		List<String> res = new ArrayList<String>();
		do{
			Class<?> [] interfaces = clazz.getInterfaces();
			if(interfaces == null || interfaces.length==0){
				break;
			}
			for(Class<?> c : interfaces){
				res.add(c.getSimpleName());
			}
			clazz = clazz.getSuperclass();
		}while(clazz != null && clazz!=Object.class);
		
		return res;
	}  
	


	public static class ServiceHandler {
		private RpcBase rpcbase;
		private HashMap<String, Method> methods = new HashMap<>();

		public Method getMethod(String key) {
			return methods.get(key);
		}

		public RpcBase getService() {
			return rpcbase;
		}

		
		public ServiceHandler(Class<?> _class) throws InstantiationException, IllegalAccessException {
			rpcbase = (RpcBase) _class.newInstance();
			searchMethod(_class);
		}

		private HashMap<String, Method> searchMethod(Class<?> clazz) {
			/**
			 * 获取 @Path
			 */
			while (clazz != Object.class) {
				Method[] meths = clazz.getDeclaredMethods();
				for (Method me : meths) {
					methods.put(me.getName(), me);
				}
				clazz = clazz.getSuperclass();
			}
			return methods;
		}
	}

}
