package cn.tom.rpc.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.tom.kit.Multimap;
import cn.tom.rpc.RpcMessage;
import cn.tom.transport.Messager.MessageCallback;

public class RpcInvoker implements InvocationHandler{
	private Map<Object, String> modules = new HashMap<>();
	private ClientGroup client; 
	private String topic;
	
	public RpcInvoker(ClientGroup client, String topic) {
		this.client = client;
		this.topic = topic;
	}
	
	public void invokeMethod(String module, MessageCallback<RpcMessage> callback, Object... args) throws Exception{
		RpcMessage msg = new RpcMessage(0,0);
		msg.setTopic(topic);
		msg.getHeader().setCompress((byte)1);
		msg.setProduct();
		msg.setModule(module);
		parseArgs(msg, args!=null ? args : new Object[0]);
		client.invokeAsync(msg, callback);
	}
	
	private Object invokeSync(Class<?> returnType, String module, Object[] args) throws Exception {
		RpcMessage msg = new RpcMessage(0,0);
		msg.setTopic(topic);
		msg.getHeader().setCompress((byte)1);
		msg.setProduct();
		msg.setModule(module);
		parseArgs(msg, args);
		msg = client.invokeSync(msg);
		return parseReturn(msg, returnType);
	}
	
	
	@SuppressWarnings("unchecked")
	private void parseArgs(RpcMessage msg, Object[] args){
		if(args.length == 0) return;
		
		if(args.length== 1){
			Object obj = args[0];
			if(obj instanceof Map){
				msg.setParam((Map<String,Object>)obj);
			}else{
				msg.setParam(Multimap.createMap("^", obj));
			}
		}else if(args.length>1&&args.length<=3){
			Object obj = args[0];
			Multimap<String, Object> map = Multimap.createMap("^", obj);
			for (int i = 1; i < args.length; i++) {
				map.put("p"+i, args[i]);
			}
			msg.setParam(map);
		}
		
		if(args.length >3){
			throw  new IllegalArgumentException("基础数据类型支持最多3个参数, 三个以上用一个Map替代");
		}
		
	}
	
	@SuppressWarnings("unchecked")
	private <T> T parseReturn(RpcMessage msg, Class<T> returnType){
		if(returnType == Map.class){
			return (T)msg.getParam() ;
		}else if(returnType == List.class){
			return (T)msg.getParams();
		}else{
			return (T)msg.getParam().get("^");
		}
	}

	@SuppressWarnings("unchecked")
	public <T> T createProxy(Class<T> clazz){  
		try {
			T t = (T) Proxy.newProxyInstance(clazz.getClassLoader(), new  Class<?>[]{clazz}, this);
			modules.put(t.hashCode(), clazz.getSimpleName());
			return t;
		} catch (IllegalArgumentException e) { 
			throw e;
		}
	} 

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
		if(args == null){
			args = new Object[0];
		}
		Object value = handleLocalMethod(proxy, method, args);
		if (value != REMOTE_METHOD_CALL) return value; 
		Class<?> returnType = method.getReturnType(); 
		String module = modules.get(proxy.hashCode())+"."+method.getName();
		return invokeSync(returnType, module, args);
	}

	protected Object handleLocalMethod(Object proxy, Method method,
			Object[] args) throws Throwable {
		String methodName = method.getName();
		Class<?>[] params = method.getParameterTypes();

		if (methodName.equals("equals") && params.length == 1
				&& params[0].equals(Object.class)) {
			Object value0 = args[0];
			if (value0 == null || !Proxy.isProxyClass(value0.getClass()))
				return new Boolean(false);
			RpcInvoker handler = (RpcInvoker) Proxy.getInvocationHandler(value0);
			return new Boolean(this.equals(handler));
		} else if (methodName.equals("hashCode") && params.length == 0) {
			return new Integer(this.hashCode());
		} else if (methodName.equals("toString") && params.length == 0) {
			return "RpcInvoker[" + this + "]";
		}
		return REMOTE_METHOD_CALL;
	} 
	
	private static final Object REMOTE_METHOD_CALL = new Object();
	
}
