package cn.tom.rpc.client;

import java.io.IOException;

import cn.tom.rpc.ClientPool;
import cn.tom.rpc.RpcClient;
import cn.tom.rpc.RpcMessage;
import cn.tom.transport.Messager.MessageCallback;

public class ClientGroup {
	ClientPool clientPool;  // product
	
	
	public ClientGroup(String address, int clientPoolSize) {
		clientPool = new ClientPool(address, clientPoolSize, true);
	}
	
	public void send(RpcMessage msg) throws Exception{
//		clientPool.get().send(msg);
	}
	
	public void invokeAsync(RpcMessage msg, MessageCallback<RpcMessage> callback) throws Exception{
		RpcClient client = null;
		try{
			client = clientPool.borrowObject();
			client.invokeAsync(msg, callback);
		}finally{
			clientPool.returnObject(client);
		}
	}
	
	public RpcMessage invokeSync(RpcMessage msg) throws Exception{
		RpcClient client = clientPool.borrowObject();
		clientPool.returnObject(client);
		return client.invokeSync(msg);
	}
	
	public  void close() throws IOException{
		clientPool.close();
	}
	
	
	
}
