package cn.tom.rpc.broker;

import java.io.IOException;

import cn.tom.rpc.MessageQueue;
import cn.tom.rpc.RpcMessage;
import cn.tom.transport.Session;

public class RpcDirectMessageQueue implements MessageQueue{
	private String topic;
	
	private int mask =0;
	
	private GroupSession sessions = new GroupSession();  // topic session
	
	public RpcDirectMessageQueue(String topic) {
		this.topic = topic;
	}
	
	public void setPushSession(Session<RpcMessage> session){
		sessions.put(session);
	}

	
	@Override
	public void produce(RpcMessage message) throws IOException {
		Session<RpcMessage> session = topicSession();
		if(session!=null && session.isActive()){
//			System.out.println("topicSession==" + session);
			session.write(message);
		}else{
			System.out.println("topSession is null");
		}
	}

	@Override
	public void consume(RpcMessage message, Session<RpcMessage> fromSession) throws IOException {
		fromSession.write(message);
	}
	
	
	@Override
	public void cleanSession(Session<RpcMessage> sess) {
		sessions.pushSessions.remove(sess.id());
		sessions.getObjects().remove(sess);
	}
	
	@Override
	public Session<RpcMessage> topicSession() {
		if(sessions.pushSessions.size()== 0) {
			return null; 
		}
		return sessions.get();
	}

	@Override
	public int getMask() {
		return 0;
	}

	@Override
	public void setMask(int value) {
		this.mask = value;
	}
	
	
	@Override
	public String toString() {
		return "Topic [" +topic+"] -- >" + sessions.getObjects() ;
	}

}
