package cn.tom.rpc.broker;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

import cn.tom.rpc.Pool;
import cn.tom.rpc.RpcMessage;
import cn.tom.transport.Session;

public class GroupSession extends Pool<Session<RpcMessage>>{

	public final Map<Long, Session<RpcMessage>> pushSessions = new ConcurrentHashMap<Long, Session<RpcMessage>>(); 
	
	public GroupSession() {
		super(new SessionFactory(), Integer.MAX_VALUE, false);
	}
	
	
	@Override
	public Session<RpcMessage> borrowObject() throws Exception { 
		Session<RpcMessage>  obj = null;
		obj = queue.poll();
		if(obj != null) return obj;
		
		obj = queue.poll(10, TimeUnit.SECONDS);
		if(obj != null) return obj;
		
		throw new TimeoutException("borrowObject wait time out");
	}
	
	public Session<RpcMessage> get() { 
		Session<RpcMessage> obj = null;
		try{
			obj =  borrowObject();
			return obj;
		} catch (Exception e) {
			e.printStackTrace();
		}finally{
			returnObject(obj);
		}
		return obj;
	}
	
	public void put(Session<RpcMessage> session) { 
		if(!pushSessions.containsKey(session.id())){
			pushSessions.put(session.id(), session);
			returnObject(session);  // 手动注入
			activeCount.incrementAndGet();
		}
	}
	
	public static class SessionFactory implements ObjectFactory<Session<RpcMessage>>{

		@Override
		public Session<RpcMessage> createObject() throws Exception {
			return null;
		}

		@Override
		public void destroyObject(Session<RpcMessage> session) {
			try {
				if(session != null){
					session.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}


		@Override
		public boolean validateObject(Session<RpcMessage> session) {
			if(session!=null && session.isActive()) {
				return true; 
			}
			return false;
		}
		
	}
	

}
