package cn.tom.rpc.broker;


import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;

import cn.tom.rpc.MessageQueue;
import cn.tom.rpc.Protocol;
import cn.tom.rpc.RpcMessage;
import cn.tom.rpc.RpcMessageAdaptor;
import cn.tom.transport.Messager.MessageHandler;
import cn.tom.transport.Session;

public class BrokerAdaptor extends RpcMessageAdaptor{
	
	private final Map<String, MessageQueue> mqTable = new ConcurrentSkipListMap<>(String.CASE_INSENSITIVE_ORDER);
	
	public BrokerAdaptor() {
		//Produce/Consume
		registerHandler(Protocol.PRODUCE, produceHandler); 
		registerHandler(Protocol.CONSUME, consumeHandler);  
		
//		registerHandler(Protocol.ROUTE, routeHandler);  
//		registerHandler(Protocol.UNCONSUME, unconsumeHandler); 
//		
//		//Topic/ConsumerGroup 
		registerHandler(Protocol.DECLARE, declareHandler);  
//		registerHandler(Protocol.QUERY, queryHandler);
//		registerHandler(Protocol.REMOVE, removeHandler);
		
		
		
	}

	
	@Override
	public void onMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {
		RpcMessage tmsg = (RpcMessage)msg;
		int ask = tmsg.getHeader().getAsk();
		
		String module =  findHandlerKey(tmsg);
		if(module == null) {
			msg.getHeader().setAsk((byte)1);
			msg.setFieldSize(0);
			sess.write(msg);
			return;
		}
		
		if(sess.isServer()){
			MessageHandler<RpcMessage> handler = handlerMap.get(module);
			if (handler != null) {
				handler.handleMessage(tmsg, sess);
				return;
			}
		}
	}
	
	private MessageHandler<RpcMessage> produceHandler = new MessageHandler<RpcMessage>() { 
		@Override
		public void handleMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {  
//			boolean ok = validateMessage(msg,sess);  // 检测消息格式
//			if(!ok) return; 
//			System.out.println("produceHandler===" + msg);
			final MessageQueue mq = findMQ(msg, sess);
			if(mq == null) return; 
			
//			int mask = mq.getMask() & (Protocol.MASK_RPC | Protocol.MASK_PROXY);  
//			boolean ack = msg.isAck();  
//			if(mask != 0){
//				ack = false;
//			} 
			
//			msg.removeHeader(Protocol.COMMAND);
//			msg.removeHeader(Protocol.ACK);  
//			msg.removeHeader(Protocol.TOKEN);
			msg.setFrom(sess.id());
			
			msg.serialMethod();
//			mq.topicSession();
			mq.produce(msg);  // 直接发送到Topic
			
//			if(ack){ 
//				ReplyKit.reply200(msg, sess);
//			}
		}

	};

	private MessageHandler<RpcMessage> consumeHandler = new MessageHandler<RpcMessage>() { 
		@Override
		public void handleMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {  
			MessageQueue mq = findMQ(msg, sess);
			if(mq == null) return; 
			long fromId = msg.getFrom();
//			System.out.println("consumeHandler === " + msg);
			Session<RpcMessage> from = getSessions().get(fromId);
			if(from != null && from.isActive()) {
				mq.consume(msg, from);    // 直接转发
			}
//			String topic = sess.attr(Protocol.TOPIC);
//			if(!msg.getTopic().equalsIgnoreCase(topic)){
//				sess.attr(Protocol.TOPIC, mq.topic()); //mark
//				
//				tracker.myServerChanged(); 
//			} 
		}
	}; 
	
	
	private MessageHandler<RpcMessage> declareHandler = new MessageHandler<RpcMessage>() { 
		@Override
		public void handleMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {  
			
			String topic = msg.getTopic();    
			
			topic = topic.trim();  
//			Integer topicMask = msg.getTopicMask();  
    		MessageQueue mq = null;
    		synchronized (mqTable) {
    			sess.setAttr("topic", topic);
    			mq = mqTable.get(topic);  
    			if(mq == null){ 
    				mq = new RpcDirectMessageQueue(topic);
    				mq.setPushSession(sess);
    				/*if(topicMask != null && (topicMask&Protocol.MASK_MEMORY) != 0){
    				} else {
    					mq = new DiskQueue(new File(config.getMqPath(), topic));  
    				} */
//	    			mq.setCreator(msg.getToken()); 
	    			mqTable.put(topic, mq);
	    			log.info("MQ Created: {}", mq);
    			}else{
    				mq.setPushSession(sess);
    				log.info("MQ Created: {}", mq);
    			}
    		} 
    		msg.getHeader().setAsk((byte)1);
    		System.out.println("msg===" + msg);
    		sess.write(msg);
		}
	}; 
	
	
	
	private MessageQueue findMQ(RpcMessage msg, Session<RpcMessage> sess) {
		String topic = msg.getTopic();
//		boolean isAck = msg.isAck();
//		if(topic == null && isAck){
//			ReplyKit.reply400(msg, sess, "Missing topic"); 
//    		return null;
//		}
		
		MessageQueue mq = mqTable.get(topic); 
//    	if(mq == null && isAck){
//    		ReplyKit.reply404(msg, sess); 
//    		return null;
//    	}   
    	return mq;
	}


	@Override
	public void heartbeat(Session<RpcMessage> sess) {
		//ignore
	}

	@Override
	public void onSessionDestroyed(Session<RpcMessage> sess) throws IOException {
		super.onSessionDestroyed(sess);
		String topic = sess.getAttr("topic");
		if(topic == null) return;
		MessageQueue mq = mqTable.get(topic); 
		if(mq!=null) {
			mq.cleanSession(sess);
		}
	}
	
	public String findHandlerKey(RpcMessage msg) {
		msg.decialMethod();
		return msg.getCmd();
	}
	
}
	