package cn.tom.rpc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import cn.tom.kit.IoBuffer;
import cn.tom.transport.IoAdaptor;
import cn.tom.transport.Messager.MessageCallback;
import cn.tom.transport.Messager.MessageHandler;
import cn.tom.transport.Session;
import cn.tom.transport.Ticket;
import cn.tom.transport.TicketManager;

public  class RpcMessageAdaptor extends IoAdaptor<RpcMessage>{

	protected Map<String, MessageHandler<RpcMessage>> handlerMap = new ConcurrentHashMap<String, MessageHandler<RpcMessage>>();
	
	@Override
	public RpcMessage decode(IoBuffer buf, Session<RpcMessage> session) {
		if(buf.remaining() <5 ) return null;
		buf.markReadIndex();
		if(buf.readByte() != (byte)0xff){ // 0xff 头标识符
			try{
				session.asyncClose();
				return null;
			}catch(Exception e){
				//ignore
			}
		}; 
		int len = buf.readInt(); // 4   
		if(buf.remaining() < len){
			buf.resetReadIndex();
			return null;
		}
		buf.resetReadIndex();
//		IoBuffer temp = IoBuffer.wrap(buf.readBytes(len +5)) ;
		RpcMessage msg = new RpcMessage();
		msg.deserialize(buf);
		return msg;
	}
	
	
	@Override
	public IoBuffer encode(RpcMessage msg, Session<RpcMessage> session) {
		msg.serialMethod();
		msg.serialize();
		return msg.toBytes();
	}
	
	
	@Override
	public Ticket createTicket(RpcMessage req, long timeout, MessageCallback<RpcMessage> callback) {
		return TicketManager.get().createTicket(req, timeout, callback);
	}
	
	
	@Override
	public Ticket removeTicket(String id) {
		return TicketManager.get().removeTicket(id);
	}
	
	
	public void registerHandler(String command, MessageHandler<RpcMessage> handler) {
		this.handlerMap.put(command, handler);
	}
	
	public String findHandlerKey(RpcMessage msg) {
		msg.decialMethod();
		return msg.getTopic();
	}
	
	@Override
	public void onMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {
		int ask = msg.getHeader().getAsk();
		if(ask == 0) {  // 请求
			String module =  findHandlerKey(msg);
			if(module == null) {
				msg.getHeader().setAsk((byte)1);
				msg.setFieldSize(0);
				sess.write(msg);
				return;
			}
			MessageHandler<RpcMessage> handler = handlerMap.get(module);
			if (handler != null) {
				handler.handleMessage(msg, sess);
				return;
			}
		}else if(ask ==1){  // 返回
			// 先验证是否有Ticket处理
			if (msg.getMsgId() == null || msg.getMsgId().isEmpty()){
				return;
			}
			Ticket ticket = removeTicket(msg.getMsgId());
			if (ticket != null) { // 此种情况为 ResultCallback 为null
				ticket.notifyResponse(msg);
				return;
			}
		}
	}

	
	@Override
	public void heartbeat(final Session<RpcMessage> sess) {
		if(sess.isServer()) return;
		
		synchronized (obj) {
			if (heartService == null || heartService.isShutdown()) {
				heartService = new ScheduledThreadPoolExecutor(1);
			}
		}
		heartService.scheduleAtFixedRate(new Runnable() {
			public void run() {
				try {
					TicketManager.get().prune(); // 回收内存
					RpcMessage msg = new RpcMessage(0, 0);
					msg.setCmd(Protocol.HEARTBEAT);
					sess.write(msg);
				} catch (Exception e) {
					// ignore
				}
			}
		},  6,  60*6, TimeUnit.SECONDS); // 60s *6
	}
	
	{
		registerHandler(Protocol.HEARTBEAT, new MessageHandler<RpcMessage>() {
			public void handleMessage(RpcMessage msg, Session<RpcMessage> sess) throws IOException {
				// ignore
				log.debug("HEARTBEAT::" + sess.id());
			}
		});
	}
	
	@Override
	public void onSessionConnected(Session<?> sess) throws IOException {
		super.onSessionConnected(sess);
		for(MessageHandler<RpcMessage> handler: onConnectOpetaions){
			handler.handleMessage(null, (Session<RpcMessage>)sess);;
		}
	}
	
	protected List<MessageHandler<RpcMessage>> onConnectOpetaions = new ArrayList<>();
	
	private ScheduledThreadPoolExecutor heartService = null;
	private Object obj = new Object();

}
