package cn.tom.rpc;

import java.util.HashMap;
import java.util.Map;

import cn.tom.kit.IoBuffer;
import cn.tom.protocol.co.ProtoUtil;
import cn.tom.protocol.co.TMessage;

public class RpcMessage extends TMessage{
	
	private Map<String, Object> method = new HashMap<>();
	
	public RpcMessage() {
		super();
	}
	
	public RpcMessage(int ask, int compress){
		super(ask, compress);
	}
	
	public void setTopic(String topic){
		method.put(Protocol.TOPIC, topic);
	}
	
	public String getTopic(){
		return (String) method.get(Protocol.TOPIC);
	}
	
	public void setFrom(long id) {
		method.put(Protocol.FROM, id);
	}

	public long getFrom() {
		return (long)method.get(Protocol.FROM);
	}
	
	public String getCmd() {
		return (String) method.get(Protocol.COMMAND);
	}
	
	public void setCmd(String cmd) {
		method.put(Protocol.COMMAND, cmd);
	}
	
	public void setCustom(){
		method.put(Protocol.COMMAND, Protocol.CONSUME);
	}
	
	public void setProduct(){
		method.put(Protocol.COMMAND, Protocol.PRODUCE);
	}
	
	public void setDeclare(){
		method.put(Protocol.COMMAND, Protocol.DECLARE);
	}
	
	public void setModule(String module){
		method.put(Protocol.MODULE, module);
	}
	
	public String getModule(){
		return (String)method.get(Protocol.MODULE);
	}
	
	public void serialMethod(){
		byte [] method = ProtoUtil.serialize(this.method).toBytes().array();
		getHeader().setMethod(method);
	}
	
	public void decialMethod(){
		Map<String, Object> method = ProtoUtil.deserialize(IoBuffer.wrap(getHeader().getMethod()));
		this.method = method;
	}
	
	@Override
	public String toString() {
		Object me = null;
		if(getHeader().getMethod()!= null) {
			me = ProtoUtil.deserialize(IoBuffer.wrap(getHeader().getMethod()));
		}
		return "method->" + me	+" params->" + params;
	}
	
}
