package cn.tom.rpc;

import java.io.IOException;

import cn.tom.transport.Messager.MessageCallback;
import cn.tom.transport.Messager.MessageHandler;
import cn.tom.transport.aio.AioClient;

public class RpcClient extends AioClient<RpcMessage>{
	
	private RpcMessageAdaptor ioAdaptor ;
	
	public RpcClient(String address) throws IOException {
		super(address);
		ioAdaptor = new RpcMessageAdaptor();
		setIoAdaptor(ioAdaptor);
	}
	
	/**
	 * service 注册 messageHandler
	 * @param topic
	 * @param handler
	 */
	public void registerHandler(String topic, MessageHandler<RpcMessage> handler){
		ioAdaptor.registerHandler(topic, handler);
	}
	
	/**
	 * 注册 连接完成事件
	 * @param handler
	 */
	public void registerOnConnectionHandler(MessageHandler<RpcMessage> handler){
		ioAdaptor.onConnectOpetaions.add(handler);
	}
	
	/**
	 * service 定义 topic
	 * @param tpoic
	 * @param callback
	 * @throws IOException
	 */
	public void delcare(String tpoic, MessageCallback<RpcMessage> callback ) throws IOException{
		RpcMessage msg = new RpcMessage(0,0);
		msg.setTopic(tpoic);
		msg.setDeclare();
		msg.getHeader().setCompress((byte)1);
		msg.setFieldSize(0);
		msg.serialMethod();
		invokeAsync(msg, callback);
	}
	
	
	/**
	 * client request 请求或提交数据
	 * @param msg
	 * @param callback
	 * @throws IOException
	 */
	public void requestAsync(RpcMessage msg, MessageCallback<RpcMessage> callback) throws IOException{
		invokeAsync(msg, callback);
	}
	
	public RpcMessage request(RpcMessage msg) throws IOException, InterruptedException{
		return invokeSync(msg);
	}
	

}
