package cn.tom.rpc;

import java.io.IOException;

public class ClientPool extends Pool<RpcClient>{
	
	public ClientPool(String serverAddress, int clientPoolSize, boolean init) {
		this(new ClientFactory(serverAddress), clientPoolSize, init);
	}
	
	public ClientPool(ObjectFactory<RpcClient> factory, int maxTotal,boolean init) {
		super(factory, maxTotal, init);
	}

	public static class ClientFactory implements ObjectFactory<RpcClient>{
		
		private String address;
		
		public ClientFactory(String address) {
			this.address = address;
		}

		@Override
		public RpcClient createObject() throws IOException {
			RpcClient client = new RpcClient(address);
			client.connectIfNeed();
			return client;
		}

		@Override
		public void destroyObject(RpcClient client) {
			try {
				if(client != null){
					client.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}

		@Override
		public boolean validateObject(RpcClient client) {
			if(client == null) return false;
			return client.hasConnected() ;
		}
	}
	

}
