/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.handler;

import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.mvc.annotation.Handler;
import cn.tom.mvc.annotation.HttpMethod;
import cn.tom.mvc.core.CocookException;
import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.ext.BeanFactory;
import cn.tom.mvc.handler.RequestMapping;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class HandlerInfo {
    private final ControllerModel controller;
    private final ConcurrentHashMap<RequestMapping, Method> methods = new ConcurrentHashMap();

    public HandlerInfo(ControllerModel controller, boolean isCoc) {
        this.controller = controller;
        if (isCoc) {
            return;
        }
        this.searchMethod(controller);
    }

    private ConcurrentHashMap<RequestMapping, Method> searchMethod(ControllerModel handler) {
        Class<?> clazz = handler.getClass();
        while (clazz != Object.class) {
            Method[] meths;
            Method[] methodArray = meths = clazz.getDeclaredMethods();
            int n = meths.length;
            int n2 = 0;
            while (n2 < n) {
                Handler.ExecMethod exec;
                Method me = methodArray[n2];
                Handler.Path path = me.getAnnotation(Handler.Path.class);
                if (path != null) {
                    HttpMethod[] httpMethodArray = path.method();
                    int n3 = httpMethodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        HttpMethod hme = httpMethodArray[n4];
                        RequestMapping maping = new RequestMapping(path.value(), hme);
                        this.methods.put(maping, me);
                        ++n4;
                    }
                }
                if ((exec = me.getAnnotation(Handler.ExecMethod.class)) != null) {
                    this.paserFieldAnotation(handler);
                    ReflectUtil.invokeMethod(me, handler);
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return this.methods;
    }

    public void paserFieldAnotation(ControllerModel handler) {
        Field[] fields;
        Field[] fieldArray = fields = handler.getClass().getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            Annotation[] anos = this.loadAnnotation(field);
            if (anos.length > 0) {
                Handler.Resource resource = field.getAnnotation(Handler.Resource.class);
                field.setAccessible(true);
                if (resource != null) {
                    try {
                        field.set(handler, BeanFactory.getInstance(resource.value()));
                    }
                    catch (Exception e) {
                        throw new CocookException(e);
                    }
                }
            }
            ++n2;
        }
    }

    private <T> Annotation[] loadAnnotation(T obj) {
        return ((AnnotatedElement)obj).getAnnotations();
    }

    public RequestMapping searchMechodByName(String name) {
        String key = String.valueOf(this.controller.getClass().getSimpleName()) + "." + name;
        RequestMapping mapping = new RequestMapping(key, null);
        if (this.methods.containsKey(mapping)) {
            return mapping;
        }
        Method me = ReflectUtil.findMethod(this.controller.getClass(), name);
        if (me != null) {
            this.methods.put(mapping, me);
        }
        return mapping;
    }

    public ControllerModel getController() {
        return this.controller;
    }

    public ConcurrentHashMap<RequestMapping, Method> getMethods() {
        return this.methods;
    }
}

