/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.handler;

import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.ext.BeanFactory;
import cn.tom.mvc.handler.Controller;
import cn.tom.mvc.handler.DefaultController;
import cn.tom.mvc.handler.DefaultNameHandler;
import cn.tom.mvc.handler.Handler;
import cn.tom.mvc.handler.HandlerInfo;
import cn.tom.mvc.handler.RequestMapping;
import cn.tom.mvc.interceptor.Interceptor;
import cn.tom.mvc.interceptor.ProxyHandler;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnnotationHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(DefaultAnnotationHandler.class);
    private final HashMap<RequestMapping, HandlerInfo> apps = new HashMap();
    private final HashMap<RequestMapping, HandlerInfo> fuz = new HashMap();
    private final ArrayList<Interceptor> interceptors = new ArrayList();

    public HashMap<RequestMapping, HandlerInfo> getApps() {
        return this.apps;
    }

    public ArrayList<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public Controller proxyApp() {
        DefaultController handlerController = new DefaultController();
        if (this.interceptors.isEmpty()) {
            return handlerController;
        }
        ProxyHandler proxy = new ProxyHandler();
        return (Controller)proxy.bind(handlerController, this.interceptors);
    }

    @Override
    public void collectApps(String _pattern, ControllerModel _app) {
        HandlerInfo handlerInfo = new HandlerInfo(_app, false);
        Handler handler = (Handler)handlers.get(DefaultNameHandler.class.getName());
        if (handler != null) {
            for (HandlerInfo handleriinfo : handler.getApps().values()) {
                if (handleriinfo.getController() != _app) continue;
                return;
            }
        }
        for (RequestMapping key : handlerInfo.getMethods().keySet()) {
            this.apps.put(key, handlerInfo);
            if (key.getPath().indexOf("{") != -1) {
                this.fuz.put(key, handlerInfo);
            }
            this.logger.info("Mapped  URL path [" + key + "] onto Controller " + _app.getClass().getSimpleName());
        }
    }

    @Override
    public void collectInterceptor(Class<?> clazz) {
        Interceptor interceptor = (Interceptor)BeanFactory.newInstance(clazz);
        this.interceptors.add(interceptor);
        this.logger.info(String.valueOf(clazz.getSimpleName()) + " Binding onto " + this.getClass().getName());
    }

    @Override
    public HandlerInfo match(RequestMapping _mapping, RequestContext context) {
        HandlerInfo handlerInfo = this.apps.get(_mapping);
        if (handlerInfo != null) {
            return handlerInfo;
        }
        for (RequestMapping mapping : this.fuz.keySet()) {
            HashMap<String, String> urlMap = new HashMap<String, String>();
            if (!matcher.doMatch(mapping.getPath(), _mapping.getPath(), true, urlMap)) continue;
            context.setUrlMap(urlMap);
            handlerInfo = this.fuz.get(mapping);
            _mapping.setPath(mapping.getPath());
            _mapping.setMethod(mapping.getMethod());
            return handlerInfo;
        }
        return null;
    }

    public HandlerInfo match2(RequestMapping _mapping, RequestContext context) {
        HandlerInfo handlerInfo = this.apps.get(_mapping);
        if (handlerInfo != null) {
            return handlerInfo;
        }
        for (RequestMapping mapping : this.apps.keySet()) {
            HashMap<String, String> urlMap = new HashMap<String, String>();
            if (!matcher.doMatch(mapping.getPath(), _mapping.getPath(), true, urlMap)) continue;
            context.setUrlMap(urlMap);
            handlerInfo = this.apps.get(mapping);
            _mapping.setPath(mapping.getPath());
            _mapping.setMethod(mapping.getMethod());
            return handlerInfo;
        }
        return null;
    }
}

