/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.ext;

import cn.tom.kit.StringUtil;
import cn.tom.mvc.ext.AntPathStringMatcher;
import cn.tom.mvc.ext.PathMatcher;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AntPathMatcher
implements PathMatcher {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?\\}");
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private String pathSeparator = "/";

    public void setPathSeparator(String pathSeparator) {
        this.pathSeparator = pathSeparator != null ? pathSeparator : DEFAULT_PATH_SEPARATOR;
    }

    @Override
    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    @Override
    public boolean match(String pattern, String path) {
        return this.doMatch(pattern, path, true, null);
    }

    @Override
    public boolean matchStart(String pattern, String path) {
        return this.doMatch(pattern, path, false, null);
    }

    /*
     * Unable to fully structure code
     */
    public boolean doMatch(String pattern, String path, boolean fullMatch, Map<String, String> uriTemplateVariables) {
        if (path.startsWith(this.pathSeparator) != pattern.startsWith(this.pathSeparator)) {
            return false;
        }
        pattDirs = StringUtil.tokenizeToStringArray(pattern, this.pathSeparator);
        pathDirs = StringUtil.tokenizeToStringArray(path, this.pathSeparator);
        pattIdxStart = 0;
        pattIdxEnd = pattDirs.length - 1;
        pathIdxStart = 0;
        pathIdxEnd = pathDirs.length - 1;
        while (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd) {
            patDir = pattDirs[pattIdxStart];
            if ("**".equals(patDir)) break;
            if (!this.matchStrings(patDir, pathDirs[pathIdxStart], uriTemplateVariables)) {
                return false;
            }
            ++pattIdxStart;
            ++pathIdxStart;
        }
        if (pathIdxStart > pathIdxEnd) {
            if (pattIdxStart > pattIdxEnd) {
                return pattern.endsWith(this.pathSeparator) != false ? path.endsWith(this.pathSeparator) : path.endsWith(this.pathSeparator) == false;
            }
            if (!fullMatch) {
                return true;
            }
            if (pattIdxStart == pattIdxEnd && pattDirs[pattIdxStart].equals("*") && path.endsWith(this.pathSeparator)) {
                return true;
            }
            i = pattIdxStart;
            while (i <= pattIdxEnd) {
                if (!pattDirs[i].equals("**")) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (pattIdxStart > pattIdxEnd) {
            return false;
        }
        if (fullMatch || !"**".equals(pattDirs[pattIdxStart])) ** GOTO lbl40
        return true;
        while (!(patDir = pattDirs[pattIdxEnd]).equals("**")) {
            if (!this.matchStrings(patDir, pathDirs[pathIdxEnd], uriTemplateVariables)) {
                return false;
            }
            --pattIdxEnd;
            --pathIdxEnd;
lbl40:
            // 2 sources

            if (pattIdxStart <= pattIdxEnd && pathIdxStart <= pathIdxEnd) continue;
        }
        if (pathIdxStart <= pathIdxEnd) ** GOTO lbl82
        i = pattIdxStart;
        while (i <= pattIdxEnd) {
            if (!pattDirs[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = pattIdxStart + 1;
            while (i <= pattIdxEnd) {
                if (pattDirs[i].equals("**")) {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == pattIdxStart + 1) {
                ++pattIdxStart;
                continue;
            }
            patLength = patIdxTmp - pattIdxStart - 1;
            strLength = pathIdxEnd - pathIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block24: {
                    j = 0;
                    while (j < patLength) {
                        subPat = pattDirs[pattIdxStart + j + 1];
                        subStr = pathDirs[pathIdxStart + i + j];
                        if (this.matchStrings(subPat, subStr, uriTemplateVariables)) {
                            ++j;
                            continue;
                        }
                        break block24;
                    }
                    foundIdx = pathIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            pattIdxStart = patIdxTmp;
            pathIdxStart = foundIdx + patLength;
lbl82:
            // 3 sources

            ** while (pattIdxStart != pattIdxEnd && pathIdxStart <= pathIdxEnd)
        }
lbl83:
        // 1 sources

        i = pattIdxStart;
        while (i <= pattIdxEnd) {
            if (!pattDirs[i].equals("**")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean matchStrings(String pattern, String str, Map<String, String> uriTemplateVariables) {
        AntPathStringMatcher matcher = new AntPathStringMatcher(pattern, str, uriTemplateVariables);
        return matcher.matchStrings();
    }

    @Override
    public String extractPathWithinPattern(String pattern, String path) {
        String[] patternParts = StringUtil.tokenizeToStringArray(pattern, this.pathSeparator);
        String[] pathParts = StringUtil.tokenizeToStringArray(path, this.pathSeparator);
        StringBuilder builder = new StringBuilder();
        int puts = 0;
        int i = 0;
        while (i < patternParts.length) {
            String patternPart = patternParts[i];
            if ((patternPart.indexOf(42) > -1 || patternPart.indexOf(63) > -1) && pathParts.length >= i + 1) {
                if (puts > 0 || i == 0 && !pattern.startsWith(this.pathSeparator)) {
                    builder.append(this.pathSeparator);
                }
                builder.append(pathParts[i]);
                ++puts;
            }
            ++i;
        }
        i = patternParts.length;
        while (i < pathParts.length) {
            if (puts > 0 || i > 0) {
                builder.append(this.pathSeparator);
            }
            builder.append(pathParts[i]);
            ++i;
        }
        return builder.toString();
    }

    @Override
    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        LinkedHashMap<String, String> variables = new LinkedHashMap<String, String>();
        boolean result = this.doMatch(pattern, path, true, variables);
        if (!result) {
            throw new IllegalStateException("Pattern \"" + pattern + "\" is not a match for \"" + path + "\"");
        }
        return variables;
    }

    @Override
    public String combine(String pattern1, String pattern2) {
        String extension2;
        String fileName2;
        if (!StringUtil.hasText(pattern1) && !StringUtil.hasText(pattern2)) {
            return "";
        }
        if (!StringUtil.hasText(pattern1)) {
            return pattern2;
        }
        if (!StringUtil.hasText(pattern2)) {
            return pattern1;
        }
        if (this.match(pattern1, pattern2)) {
            return pattern2;
        }
        if (pattern1.endsWith("/*")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return String.valueOf(pattern1.substring(0, pattern1.length() - 1)) + pattern2.substring(1);
            }
            return String.valueOf(pattern1.substring(0, pattern1.length() - 1)) + pattern2;
        }
        if (pattern1.endsWith("/**")) {
            if (pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return String.valueOf(pattern1) + pattern2;
            }
            return String.valueOf(pattern1) + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        int dotPos1 = pattern1.indexOf(46);
        if (dotPos1 == -1) {
            if (pattern1.endsWith(DEFAULT_PATH_SEPARATOR) || pattern2.startsWith(DEFAULT_PATH_SEPARATOR)) {
                return String.valueOf(pattern1) + pattern2;
            }
            return String.valueOf(pattern1) + DEFAULT_PATH_SEPARATOR + pattern2;
        }
        String fileName1 = pattern1.substring(0, dotPos1);
        String extension1 = pattern1.substring(dotPos1);
        int dotPos2 = pattern2.indexOf(46);
        if (dotPos2 != -1) {
            fileName2 = pattern2.substring(0, dotPos2);
            extension2 = pattern2.substring(dotPos2);
        } else {
            fileName2 = pattern2;
            extension2 = "";
        }
        String fileName = fileName1.endsWith("*") ? fileName2 : fileName1;
        String extension = extension1.startsWith("*") ? extension2 : extension1;
        return String.valueOf(fileName) + extension;
    }

    @Override
    public Comparator<String> getPatternComparator(String path) {
        return new AntPatternComparator(path);
    }

    private static class AntPatternComparator
    implements Comparator<String> {
        private final String path;

        private AntPatternComparator(String path) {
            this.path = path;
        }

        @Override
        public int compare(String pattern1, String pattern2) {
            int pattern2Length;
            int bracketCount2;
            int totalCount2;
            if (pattern1 == null && pattern2 == null) {
                return 0;
            }
            if (pattern1 == null) {
                return 1;
            }
            if (pattern2 == null) {
                return -1;
            }
            boolean pattern1EqualsPath = pattern1.equals(this.path);
            boolean pattern2EqualsPath = pattern2.equals(this.path);
            if (pattern1EqualsPath && pattern2EqualsPath) {
                return 0;
            }
            if (pattern1EqualsPath) {
                return -1;
            }
            if (pattern2EqualsPath) {
                return 1;
            }
            int wildCardCount1 = this.getWildCardCount(pattern1);
            int wildCardCount2 = this.getWildCardCount(pattern2);
            int bracketCount1 = StringUtil.countOccurrencesOf(pattern1, "{");
            int totalCount1 = wildCardCount1 + bracketCount1;
            if (totalCount1 != (totalCount2 = wildCardCount2 + (bracketCount2 = StringUtil.countOccurrencesOf(pattern2, "{")))) {
                return totalCount1 - totalCount2;
            }
            int pattern1Length = this.getPatternLength(pattern1);
            if (pattern1Length != (pattern2Length = this.getPatternLength(pattern2))) {
                return pattern2Length - pattern1Length;
            }
            if (wildCardCount1 < wildCardCount2) {
                return -1;
            }
            if (wildCardCount2 < wildCardCount1) {
                return 1;
            }
            if (bracketCount1 < bracketCount2) {
                return -1;
            }
            if (bracketCount2 < bracketCount1) {
                return 1;
            }
            return 0;
        }

        private int getWildCardCount(String pattern) {
            if (pattern.endsWith(".*")) {
                pattern = pattern.substring(0, pattern.length() - 2);
            }
            return StringUtil.countOccurrencesOf(pattern, "*");
        }

        private int getPatternLength(String pattern) {
            Matcher m = VARIABLE_PATTERN.matcher(pattern);
            return m.replaceAll("#").length();
        }
    }
}

