/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.core;

import cn.tom.kit.StringUtil;
import cn.tom.kit.json.JsonUtil;
import cn.tom.mvc.config.Constants;
import cn.tom.mvc.core.CocookException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class RequestContext {
    private ServletContext context;
    private HttpSession session;
    private HttpServletRequest req;
    private HttpServletResponse res;
    private static String encoding = Constants.getEncoding();
    private Map<String, Cookie> cookies = new HashMap<String, Cookie>();
    private Map<String, String> urlMap = new HashMap<String, String>();
    private static final ThreadLocal<RequestContext> contexts = new ThreadLocal();
    public static String basePath;

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public Map<String, Cookie> getCookies() {
        return this.cookies;
    }

    public RequestContext() {
    }

    public RequestContext(ServletContext ctx, HttpServletRequest req, HttpServletResponse res) {
        this.context = ctx;
        this.req = req;
        this.res = res;
        this.session = req.getSession();
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie ck = cookieArray[n2];
                this.cookies.put(ck.getName(), ck);
                ++n2;
            }
        }
    }

    public static RequestContext begin(ServletContext ctx, HttpServletRequest req, HttpServletResponse res) {
        RequestContext rc = new RequestContext(ctx, req, res);
        contexts.set(rc);
        return rc;
    }

    public static RequestContext get() {
        return contexts.get();
    }

    public void end() {
        this.context = null;
        this.req = null;
        this.res = null;
        this.session = null;
        this.cookies = null;
        contexts.remove();
    }

    public void forward(String url, boolean config) throws IOException, ServletException {
        if (config) {
            url = this.getRealPage(url);
        }
        this.req.getRequestDispatcher(url).forward((ServletRequest)this.req, (ServletResponse)this.res);
    }

    public String getRealPage(String url) {
        return String.valueOf(Constants.getPageContext()) + "/" + url + Constants.getPageSuffix();
    }

    public void redirect(String url) throws IOException {
        this.res.sendRedirect(url);
    }

    public void error(int code, String ... msg) throws IOException {
        if (msg.length > 0) {
            this.res.sendError(code, msg[0]);
        } else {
            this.res.sendError(code);
        }
    }

    public void forbidden() throws IOException {
        this.error(403, new String[0]);
    }

    public void notfound() throws IOException {
        this.error(404, new String[0]);
    }

    public void printData(String contentType, Object data) throws IOException {
        this.res.setContentType(contentType);
        this.res.getWriter().print(data);
    }

    public void printHTML(Object data) throws IOException {
        this.printData("text/html; charset=" + encoding, data);
    }

    public void printJSON(Object obj) throws IOException {
        try {
            String data = obj instanceof String ? (String)obj : JsonUtil.serialize(obj);
            this.printData("application/json;charset=" + encoding, data);
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public String[] getparams(String name) {
        return this.req.getParameterValues(name);
    }

    public String getParameterGBK(String name) throws UnsupportedEncodingException {
        String temp = this.req.getParameter(name);
        return !StringUtil.isEmpty(temp) ? new String(temp.getBytes("ISO-8859-1"), "GBK").trim() : "";
    }

    public String getParameterUTF(String name) throws UnsupportedEncodingException {
        String temp = this.req.getParameter(name);
        return !StringUtil.isEmpty(temp) ? new String(temp.getBytes("ISO-8859-1"), "UTF-8").trim() : "";
    }

    public String getParameter(String name) {
        return this.req.getParameter(name);
    }

    public void setHeader(String param1, String param2) {
        this.res.setHeader(param1, param2);
    }

    public void setContentType(String conType) {
        this.res.setContentType(conType);
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        this.req.setCharacterEncoding(encoding);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.res.getOutputStream();
    }

    public Object getAttribute(String name) {
        return this.req.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.req.setAttribute(name, value);
    }

    public void setAttributs(Map<String, ?> params) {
        for (Map.Entry<String, ?> e : params.entrySet()) {
            this.req.setAttribute(e.getKey(), e.getValue());
        }
    }

    public Object getSessionAttribute(String name) {
        return this.req.getSession().getAttribute(name);
    }

    public void setSessionAttribute(String name, Object value) {
        this.req.getSession().setAttribute(name, value);
    }

    public void removeParam(String name) {
        this.req.removeAttribute(name);
    }

    public void removeSessionParam(String name) {
        this.req.getSession().removeAttribute(name);
    }

    public Map<String, Object> getAttributsMap() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Enumeration attrs = this.req.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            parameterMap.put(attrName, this.req.getAttribute(attrName));
        }
        return parameterMap;
    }

    public Map<String, String> getParameterMap() {
        Map hm = this.req.getParameterMap();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String key : hm.keySet()) {
            String[] values = (String[])hm.get(key);
            String pamValues = "";
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (pamValues.length() > 0) {
                    pamValues = String.valueOf(pamValues) + ",";
                }
                pamValues = String.valueOf(pamValues) + value.trim();
                parameterMap.put(key, pamValues);
                ++n2;
            }
        }
        return parameterMap;
    }

    public Map<String, String> getParameterMapGBK() throws UnsupportedEncodingException {
        Map hm = this.req.getParameterMap();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String key : hm.keySet()) {
            String[] values = (String[])hm.get(key);
            String pamValues = "";
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                value = new String(value.getBytes(Charset.forName("ISO-8859-1")), Charset.forName("GBK"));
                if (pamValues.length() > 0) {
                    pamValues = String.valueOf(pamValues) + ",";
                }
                pamValues = String.valueOf(pamValues) + value.trim();
                parameterMap.put(key, pamValues);
                ++n2;
            }
        }
        return parameterMap;
    }

    public Map<String, String> getParameterMapUTF() {
        Map hm = this.req.getParameterMap();
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (String key : hm.keySet()) {
            String[] values = (String[])hm.get(key);
            String pamValues = "";
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                value = new String(value.getBytes(Charset.forName("ISO-8859-1")), Charset.forName("UTF-8"));
                if (pamValues.length() > 0) {
                    pamValues = String.valueOf(pamValues) + ",";
                }
                pamValues = String.valueOf(pamValues) + value.trim();
                parameterMap.put(key, pamValues);
                ++n2;
            }
        }
        return parameterMap;
    }

    public Cookie getCookie(String name) {
        return this.cookies.get(name);
    }

    public void setCookie(String name, String value, int maxAge) {
        this.setCookie(name, value, maxAge, true);
    }

    public void setCookie(String name, String value, int maxAge, boolean all_sub_domain) {
        String serverName;
        String domain;
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        if (all_sub_domain && (domain = this.getDomainOfServerName(serverName = this.req.getServerName())) != null && domain.indexOf(46) != -1) {
            cookie.setDomain(String.valueOf('.') + domain);
        }
        cookie.setPath("/");
        this.res.addCookie(cookie);
    }

    public void deleteCookie(String name, boolean all_sub_domain) {
        this.setCookie(name, null, 0, all_sub_domain);
    }

    public String getIpAddr() {
        String ip = this.req.getHeader("X-REAL-IP");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.req.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.req.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = this.req.getRemoteAddr();
        }
        return ip;
    }

    public String getDomainOfServerName(String host) {
        if (this.isIPAddr(host)) {
            return null;
        }
        String[] names = host.split("\\.");
        int len = names.length;
        if (len == 1) {
            return null;
        }
        if (len == 3) {
            return this.makeup(names[len - 2], names[len - 1]);
        }
        if (len > 3) {
            String dp = names[len - 2];
            if (dp.equalsIgnoreCase("com") || dp.equalsIgnoreCase("gov") || dp.equalsIgnoreCase("net") || dp.equalsIgnoreCase("edu") || dp.equalsIgnoreCase("org")) {
                return this.makeup(names[len - 3], names[len - 2], names[len - 1]);
            }
            return this.makeup(names[len - 2], names[len - 1]);
        }
        return host;
    }

    public boolean isIPAddr(String addr) {
        if (StringUtil.isEmpty(addr)) {
            return false;
        }
        String[] ips = addr.split("\\.");
        if (ips.length != 4) {
            return false;
        }
        try {
            int ipa = Integer.parseInt(ips[0]);
            int ipb = Integer.parseInt(ips[1]);
            int ipc = Integer.parseInt(ips[2]);
            int ipd = Integer.parseInt(ips[3]);
            return ipa >= 0 && ipa <= 255 && ipb >= 0 && ipb <= 255 && ipc >= 0 && ipc <= 255 && ipd >= 0 && ipd <= 255;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String makeup(String ... ps) {
        StringBuilder s = new StringBuilder();
        int idx = 0;
        while (idx < ps.length) {
            if (idx > 0) {
                s.append('.');
            }
            s.append(ps[idx]);
            ++idx;
        }
        return s.toString();
    }

    public String getBasePath() {
        if (basePath == null) {
            basePath = String.valueOf(this.req.getScheme()) + "://" + this.req.getServerName() + ":" + this.req.getServerPort() + this.req.getContextPath();
        }
        return basePath;
    }

    public Map<String, String> getUrlMap() {
        return this.urlMap;
    }

    public void setUrlMap(Map<String, String> urlMap) {
        this.urlMap = urlMap;
    }
}

