/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.core;

import cn.tom.kit.clazz.Converter;
import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.kit.io.FileUtil;
import cn.tom.mvc.annotation.ContentType;
import cn.tom.mvc.annotation.Handler;
import cn.tom.mvc.annotation.Response;
import cn.tom.mvc.core.CocookException;
import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.ext.BeanFactory;
import cn.tom.mvc.ext.HTTPConverter;
import cn.tom.mvc.ext.JavassistUtil;
import cn.tom.mvc.interceptor.ActionInvocation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class ControllerInvoke {
    private ActionInvocation actionInvocation;
    private ControllerModel control;

    public ControllerInvoke(ActionInvocation _actionInvocation) {
        this.actionInvocation = _actionInvocation;
        this.control = _actionInvocation.getAppControl();
    }

    public boolean beforeControl() throws Exception {
        Method m = this.control.getClass().getMethod("before", RequestContext.class, Map.class);
        return (Boolean)m.invoke((Object)this.control, this.actionInvocation.getRequestContext(), this.actionInvocation.getParaMap());
    }

    private Field[] loadField(Class<?> c) {
        return c.getDeclaredFields();
    }

    public void paserFieldAnotation() throws IllegalArgumentException, IllegalAccessException {
        Field[] fields;
        if (this.control.isPaserField()) {
            return;
        }
        Field[] fieldArray = fields = this.loadField(this.control.getClass());
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Handler.Resource resource;
            Field field = fieldArray[n2];
            Annotation[] anos = this.loadAnnotation(field);
            if (anos.length > 0 && (resource = field.getAnnotation(Handler.Resource.class)) != null) {
                try {
                    field.setAccessible(true);
                    field.set(this.control, BeanFactory.getInstance(resource.value()));
                }
                catch (Exception e) {
                    throw new CocookException(e);
                }
            }
            ++n2;
        }
        this.control.setPaserField(true);
    }

    private <T> Annotation[] loadAnnotation(T obj) {
        return ((AnnotatedElement)obj).getAnnotations();
    }

    public Object parserControllerMethod() throws Exception {
        String methodUrl = this.actionInvocation.getMapping().getPath();
        Method me = this.actionInvocation.getMethod();
        Object obj = null;
        if (me == null) {
            this.actionInvocation.getRequestContext().error(404, String.valueOf(methodUrl) + " not found on action[" + this.actionInvocation.getAppControl().getClass().getSimpleName() + "]");
            return null;
        }
        if (this.beforeControl()) {
            Annotation[] anos = this.loadAnnotation(me);
            obj = anos.length == 0 ? this.invoke(me) : this.paserMethodAnnotation(me);
        }
        return obj;
    }

    private Object paserMethodAnnotation(Method _me) throws IOException {
        Object obj = this.invoke(_me);
        if ((obj = this.control.extAnnnotation(obj, _me, this.actionInvocation.getParaMap())) == null) {
            return null;
        }
        if (_me.isAnnotationPresent(Response.Json.class)) {
            this.actionInvocation.getRequestContext().printJSON(obj);
            return null;
        }
        if (_me.isAnnotationPresent(Response.Html.class)) {
            this.actionInvocation.getRequestContext().printHTML(obj);
            return null;
        }
        if (_me.isAnnotationPresent(Response.Stream.class)) {
            this.paserStream(_me, obj);
            return null;
        }
        return obj;
    }

    private void paserStream(Method _me, Object _obj) throws IOException {
        if (_obj instanceof InputStream) {
            Response.Stream in = _me.getAnnotation(Response.Stream.class);
            if (in.value() == ContentType.Image) {
                this.actionInvocation.getResponse().setContentType("image/jpeg");
                FileUtil.copy((InputStream)_obj, (OutputStream)this.actionInvocation.getResponse().getOutputStream());
                return;
            }
        } else {
            throw new IllegalArgumentException("Reflect.paserMethodAnnotation: error return type,no inputStream found");
        }
        FileUtil.copy((InputStream)_obj, (OutputStream)this.actionInvocation.getResponse().getOutputStream());
    }

    private Object invoke(Method _me) {
        String[] paramNames = null;
        Class<?>[] _class = _me.getParameterTypes();
        Object[] params = new Object[_class.length];
        int i = 0;
        while (i < _class.length) {
            Class<?> clazz = _class[i];
            if (HTTPConverter.canConvertRequestContext(clazz)) {
                params[i] = HTTPConverter.coverterclass2RequestContext(clazz, this.actionInvocation, new Object[0]);
            } else if (Converter.canConvertValue(clazz)) {
                if (paramNames == null) {
                    paramNames = JavassistUtil.getMethodParamNames(this.control.getClass(), _me);
                }
                params[i] = Converter.coverterClass2Value(clazz, null, this.actionInvocation.getParaMap().get(paramNames[i]));
            } else {
                params[i] = ReflectUtil.mapToBean(this.actionInvocation.getParaMap(), clazz);
            }
            ++i;
        }
        return ReflectUtil.invokeMethod(this.control, _me, params);
    }
}

