/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc;

import cn.tom.kit.Helper;
import cn.tom.kit.io.Resource;
import cn.tom.mvc.handler.CocookServlet;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class UndertowStart {
    private Class<?> clazzLoader;
    private int port = 80;
    private String host = "localhost";
    private String ctxpath = "/";
    private String rpath = "/";
    private DeploymentInfo servletBuilder;

    public UndertowStart(Class<?> clazz) {
        this.clazzLoader = clazz;
    }

    public UndertowStart(DeploymentInfo servletBuilder) {
        this.servletBuilder = servletBuilder;
    }

    public UndertowStart init(String[] args) {
        this.port = Helper.option(args, "-p", 80);
        this.ctxpath = Helper.option(args, "-ctxpath", "/");
        this.host = Helper.option(args, "-h", "127.0.0.1");
        this.rpath = Helper.option(args, "-rpath", "/");
        this.servletBuilder = Servlets.deployment().setClassLoader(this.clazzLoader.getClassLoader()).setContextPath(this.ctxpath).setDeploymentName("");
        this.initWebRoot(this.rpath);
        return this;
    }

    public UndertowStart addInitParam(String name, String value) {
        this.servletBuilder.addInitParameter(name, value);
        return this;
    }

    public UndertowStart initWebRoot(String path) {
        try {
            URL url = Resource.getDefaultClassLoader().getResource("");
            if (url == null) {
                return this;
            }
            File classpath = new File(url.getFile()).getParentFile();
            FileResourceManager resource = new FileResourceManager(new File(classpath.getCanonicalPath(), path), 0L);
            this.servletBuilder.setResourceManager((ResourceManager)resource);
            UndertowLogger.ROOT_LOGGER.infof("init webroot rpath %s", (Object)resource.getBase());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public UndertowStart addServlet(Class<? extends Servlet> clazz, String mapping, int loadOnStartup) {
        ServletInfo servletInfo = Servlets.servlet(clazz).addMapping(mapping).setLoadOnStartup(Integer.valueOf(loadOnStartup));
        this.servletBuilder.addServlets(new ServletInfo[]{servletInfo});
        return this;
    }

    public UndertowStart addServlet(ServletInfo servletInfo) {
        this.servletBuilder.addServlet(servletInfo);
        return this;
    }

    public UndertowStart addlistener(ListenerInfo listenerInfo) {
        this.servletBuilder.addListener(listenerInfo);
        return this;
    }

    public UndertowStart addCocookServlet() {
        ServletInfo servletInfo = Servlets.servlet(CocookServlet.class).addMapping("/").setLoadOnStartup(Integer.valueOf(1));
        this.servletBuilder.addServlet(servletInfo);
        return this;
    }

    public UndertowStart addlistener(Class<? extends EventListener> clazz) {
        this.servletBuilder.addListener(new ListenerInfo(clazz));
        return this;
    }

    public UndertowStart addFilter(FilterInfo filterInfo) {
        this.servletBuilder.addFilter(filterInfo);
        return this;
    }

    public UndertowStart addFilter(Class<? extends Filter> filterClass) {
        this.servletBuilder.addFilter(new FilterInfo(filterClass.getName(), filterClass));
        return this;
    }

    public void start() throws ServletException {
        DeploymentManager manager = Servlets.defaultContainer().addDeployment(this.servletBuilder);
        manager.deploy();
        HttpHandler servletHandler = manager.start();
        PathHandler path = Handlers.path((HttpHandler)Handlers.redirect((String)this.ctxpath)).addPrefixPath(this.ctxpath, servletHandler);
        Undertow server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)path).build();
        server.start();
        UndertowLogger.ROOT_LOGGER.infof("Configuring listener with protocol %s for interface %s and port %s", (Object)"http", (Object)this.host, (Object)this.port);
    }
}

