/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Resource {
    private String path;
    private ClassLoader classLoader;
    private Class<?> clazz;
    private String webRoot;

    public Resource(String path) {
        this(path, (ClassLoader)null);
    }

    public Resource(String path, ClassLoader classLoader) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        this.classLoader = classLoader != null ? classLoader : Resource.getDefaultClassLoader();
    }

    public Resource(String path, Class<?> clazz) {
        this.path = path;
        this.clazz = clazz;
    }

    public void setWebRoot(String webRoot) {
        this.webRoot = webRoot;
    }

    public String getPhysicalwebapp() throws IOException {
        if (this.webRoot == null) {
            URL url = Resource.getDefaultClassLoader().getResource("");
            if (url == null) {
                return null;
            }
            this.webRoot = url.getFile();
            this.webRoot = new File(this.webRoot).getParentFile().getParentFile().getCanonicalPath();
            return this.webRoot;
        }
        return this.webRoot;
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = Resource.class.getClassLoader();
        }
        return cl;
    }

    public boolean exists() {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        return url != null;
    }

    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        if (this.clazz != null) {
            is = this.clazz.getResourceAsStream(this.path);
        } else if (this.classLoader != null) {
            is = this.classLoader.getResourceAsStream(this.path);
        }
        if (is == null) {
            is = new FileInputStream(new File(this.getPhysicalwebapp(), this.path));
        }
        return is;
    }

    public URL getURL() throws IOException {
        URL url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(String.valueOf(this.path) + " cannot be resolved to URL because it does not exist");
        }
        return url;
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : this.clazz.getClassLoader();
    }
}

