/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit.clazz;

import cn.tom.kit.clazz.ReflectUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

public class Converter {
    private static final HashMap<Class<?>, Method> class2Value = new HashMap<Class<?>, Method>(){
        {
            try {
                Class<String> s = String.class;
                this.put(Boolean.TYPE, Boolean.class.getMethod("parseBoolean", s));
                this.put(Byte.TYPE, Byte.class.getMethod("parseByte", s));
                this.put(Double.TYPE, Double.class.getMethod("parseDouble", s));
                this.put(Float.TYPE, Float.class.getMethod("parseFloat", s));
                this.put(Integer.TYPE, Integer.class.getMethod("parseInt", s));
                this.put(Long.TYPE, Long.class.getMethod("parseLong", s));
                this.put(Short.TYPE, Short.class.getMethod("parseShort", s));
                this.put(String.class, String.class.getMethod("valueOf", Object.class));
                this.put(Boolean.class, Boolean.class.getMethod("parseBoolean", s));
                this.put(Byte.class, Byte.class.getMethod("parseByte", s));
                this.put(Double.class, Double.class.getMethod("parseDouble", s));
                this.put(Float.class, Float.class.getMethod("parseFloat", s));
                this.put(Integer.class, Integer.class.getMethod("parseInt", s));
                this.put(Long.class, Long.class.getMethod("parseLong", s));
                this.put(Short.class, Short.class.getMethod("parseShort", s));
                this.put(Date.class, Converter.class.getMethod("parserDate", s));
                this.put(Timestamp.class, Converter.class.getMethod("parserDateTime", s));
            }
            catch (Exception e) {
                throw new Error(e);
            }
        }
    };
    private static final HashMap<Type, Class<?>> type2Class = new HashMap();
    private static final HashMap<String, Class<?>> name2Class;
    private static final HashMap<Class<?>, String> class2Name;

    static {
        type2Class.put(Boolean.TYPE, Boolean.class);
        type2Class.put(Byte.TYPE, Byte.class);
        type2Class.put(Character.TYPE, Character.class);
        type2Class.put(Double.TYPE, Double.class);
        type2Class.put(Float.TYPE, Float.class);
        type2Class.put(Integer.TYPE, Integer.class);
        type2Class.put(Long.TYPE, Long.class);
        type2Class.put(Short.TYPE, Short.class);
        name2Class = new HashMap();
        name2Class.put("java.lang.Boolean.TYPE", Boolean.class);
        name2Class.put("java.lang.Byte.TYPE", Byte.class);
        name2Class.put("java.lang.Character.TYPE", Character.class);
        name2Class.put("java.lang.Double.TYPE", Double.class);
        name2Class.put("java.lang.Float.TYPE", Float.class);
        name2Class.put("java.lang.Integer.TYPE", Integer.class);
        name2Class.put("java.lang.Long.TYPE", Long.class);
        name2Class.put("java.lang.Short.TYPE", Short.class);
        name2Class.put("boolean", Boolean.class);
        name2Class.put("byte", Byte.class);
        name2Class.put("char", Character.class);
        name2Class.put("double", Double.class);
        name2Class.put("float", Float.class);
        name2Class.put("int", Integer.class);
        name2Class.put("long", Long.class);
        name2Class.put("short", Short.class);
        name2Class.put("java.lang.Boolean", Boolean.class);
        name2Class.put("java.lang.Byte", Byte.class);
        name2Class.put("java.lang.Character", Character.class);
        name2Class.put("java.lang.Double", Double.class);
        name2Class.put("java.lang.Float", Float.class);
        name2Class.put("java.lang.Integer", Integer.class);
        name2Class.put("java.lang.Long", Long.class);
        name2Class.put("java.lang.Short", Short.class);
        name2Class.put("Boolean", Boolean.class);
        name2Class.put("Byte", Byte.class);
        name2Class.put("Character", Character.class);
        name2Class.put("Double", Double.class);
        name2Class.put("Float", Float.class);
        name2Class.put("Integer", Integer.class);
        name2Class.put("Long", Long.class);
        name2Class.put("Short", Short.class);
        name2Class.put(null, Void.TYPE);
        name2Class.put("string", String.class);
        name2Class.put("String", String.class);
        name2Class.put("java.lang.String", String.class);
        class2Name = new HashMap();
        class2Name.put(Boolean.TYPE, "boolean");
        class2Name.put(Byte.TYPE, "byte");
        class2Name.put(Character.TYPE, "char");
        class2Name.put(Double.TYPE, "double");
        class2Name.put(Float.TYPE, "float");
        class2Name.put(Integer.TYPE, "int");
        class2Name.put(Long.TYPE, "long");
        class2Name.put(Short.TYPE, "short");
        class2Name.put(Void.TYPE, "void");
        class2Name.put(Boolean.class, "java.lang.Boolean");
        class2Name.put(Byte.class, "java.lang.Byte");
        class2Name.put(Character.class, "java.lang.Character");
        class2Name.put(Double.class, "java.lang.Double");
        class2Name.put(Float.class, "java.lang.Float");
        class2Name.put(Integer.class, "java.lang.Integer");
        class2Name.put(Long.class, "java.lang.Long");
        class2Name.put(Short.class, "java.lang.Short");
        class2Name.put(null, "void");
        class2Name.put(String.class, "java.lang.String");
    }

    public static Date parserDate(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parserDateTime(String date) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static boolean canConvertValue(Class<?> clazz) {
        return class2Value.containsKey(clazz);
    }

    public static <T> T coverterClass2Value(Class<T> _class, Object obj, Object ... param) {
        try {
            return (T)class2Value.get(_class).invoke(obj, param);
        }
        catch (Exception e) {
            ReflectUtil.handleReflectionException(e);
            return null;
        }
    }

    public static Type convertType2Class(Type type) {
        if (type2Class.containsKey(type)) {
            return type2Class.get(type);
        }
        return type;
    }

    public static Class<?> convertName2Class(String name) {
        if (name2Class.containsKey(name)) {
            return name2Class.get(name);
        }
        return null;
    }

    public static String convertclass2Name(String name) {
        if (class2Name.containsKey(name)) {
            return class2Name.get(name);
        }
        return null;
    }
}

