/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.hotswap;

import cn.tom.boot.UndertowServer;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HotSwapWatcher
extends Thread {
    protected UndertowServer undertowServer;
    protected int watchingInterval = 500;
    protected volatile boolean running = true;
    protected List<Path> watchingPaths;
    private WatchKey watchKey;

    public HotSwapWatcher(UndertowServer undertowServer) {
        this.setName("HotSwapWatcher");
        this.setDaemon(false);
        this.setPriority(10);
        this.undertowServer = undertowServer;
        this.watchingPaths = this.buildWatchingPaths();
        System.out.println("watchingPaths ->" + this.watchingPaths);
    }

    protected List<Path> buildWatchingPaths() {
        HashSet<String> watchingDirSet = new HashSet<String>();
        String classpath = System.getProperty("java.class.path");
        String[] classPathArray = classpath.split(File.pathSeparator);
        String[] stringArray = classPathArray;
        int n = classPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            String classPath = stringArray[n2];
            this.buildDirs(new File(classPath.trim()), watchingDirSet);
            ++n2;
        }
        ArrayList dirList = new ArrayList(watchingDirSet);
        Collections.sort(dirList);
        ArrayList<Path> pathList = new ArrayList<Path>(dirList.size());
        for (String dir : dirList) {
            pathList.add(Paths.get(dir, new String[0]));
        }
        return pathList;
    }

    private void buildDirs(File file, Set<String> watchingDirSet) {
        if (file.isDirectory()) {
            File[] fileList;
            watchingDirSet.add(file.getPath());
            File[] fileArray = fileList = file.listFiles();
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                this.buildDirs(f, watchingDirSet);
                ++n2;
            }
        } else if (file.isFile() && file.getName().endsWith(".jar")) {
            watchingDirSet.add(file.getParentFile().getPath());
        }
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected void doRun() throws IOException, InterruptedException {
        WatchService watcher = FileSystems.getDefault().newWatchService();
        this.addShutdownHook(watcher);
        for (Path path : this.watchingPaths) {
            path.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
        }
        while (this.running) {
            try {
                this.watchKey = watcher.take();
                if (this.watchKey == null) {
                    continue;
                }
            }
            catch (Throwable e) {
                this.running = false;
                if (!(e instanceof InterruptedException)) break;
                Thread.currentThread().interrupt();
                break;
            }
            List<WatchEvent<?>> watchEvents = this.watchKey.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                String fileName = event.context().toString();
                System.out.println("hotSwapWatcher.fileName ->" + fileName);
                if (!fileName.endsWith(".class") && !fileName.endsWith(".jar")) continue;
                if (fileName.endsWith(".jar")) {
                    HotSwapWatcher.sleep(10000L);
                }
                if (!this.undertowServer.isStarted()) continue;
                this.undertowServer.restart();
                this.resetWatchKey();
                while ((this.watchKey = watcher.poll()) != null) {
                    this.watchKey.pollEvents();
                    this.resetWatchKey();
                }
                break block4;
            }
            this.resetWatchKey();
        }
    }

    private void resetWatchKey() {
        if (this.watchKey != null) {
            this.watchKey.reset();
            this.watchKey = null;
        }
    }

    protected void addShutdownHook(final WatchService watcher) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    watcher.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void exit() {
        try {
            super.interrupt();
            this.running = false;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws InterruptedException {
    }
}

