/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.hotswap;

import java.io.File;
import java.util.ArrayList;

public class HotSwapResolver {
    protected String[] classPathDirs;
    protected String[] systemClassPrefix = new String[]{"java.", "javax.", "sun.", "com.sun.", "cn.tom."};
    protected String[] hotSwapClassPrefix = new String[]{"net.sf.ehcache.", "redis.clients.", "org.nustaq.", "net.dreamlu."};

    public HotSwapResolver(String[] classPathDirs) {
        this.classPathDirs = classPathDirs != null ? classPathDirs : new String[0];
    }

    public boolean isSystemClass(String className) {
        String[] stringArray = this.systemClassPrefix;
        int n = this.systemClassPrefix.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (className.startsWith(s)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isHotSwapClass(String className) {
        String[] stringArray = this.hotSwapClassPrefix;
        int n = this.hotSwapClassPrefix.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (className.startsWith(s)) {
                return true;
            }
            ++n2;
        }
        return this.findClassInClassPathDirs(className);
    }

    protected boolean findClassInClassPathDirs(String className) {
        String fileName = className.replace('.', '/').concat(".class");
        if (this.classPathDirs.length == 1) {
            if (this.findFile(this.classPathDirs[0], fileName)) {
                return true;
            }
        } else {
            String[] stringArray = this.classPathDirs;
            int n = this.classPathDirs.length;
            int n2 = 0;
            while (n2 < n) {
                String dir = stringArray[n2];
                if (this.findFile(dir, fileName)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean findFile(String filePath, String fileName) {
        File file = new File(String.valueOf(filePath) + fileName);
        return file.isFile();
    }

    public synchronized void addSystemClassPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = this.systemClassPrefix;
        int n = this.systemClassPrefix.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        list.add(prefix.trim());
        this.systemClassPrefix = list.toArray(new String[list.size()]);
    }

    public synchronized void addHotSwapClassPrefix(String prefix) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = this.hotSwapClassPrefix;
        int n = this.hotSwapClassPrefix.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            list.add(s);
            ++n2;
        }
        list.add(prefix.trim());
        this.hotSwapClassPrefix = list.toArray(new String[list.size()]);
    }
}

