/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.hotswap;

import cn.tom.hotswap.HotSwapClassLoader;
import cn.tom.hotswap.HotSwapResolver;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderKit {
    protected URL[] classPathUrls = this.buildClassPathUrls();
    protected ClassLoader parentClassLoader;
    protected HotSwapResolver hotSwapResolver;
    protected ClassLoader currentClassLoader;
    protected String configClassPathDirectory = null;

    public ClassLoaderKit(ClassLoader parentClassLoader, HotSwapResolver hotSwapResolver) {
        this.parentClassLoader = parentClassLoader;
        this.hotSwapResolver = hotSwapResolver;
        this.currentClassLoader = new HotSwapClassLoader(this.classPathUrls, parentClassLoader, hotSwapResolver);
    }

    public ClassLoader getClassLoader() {
        return this.currentClassLoader;
    }

    public ClassLoader replaceClassLoader() {
        this.currentClassLoader = new HotSwapClassLoader(this.classPathUrls, this.parentClassLoader, this.hotSwapResolver);
        return this.currentClassLoader;
    }

    protected URL[] buildClassPathUrls() {
        String[] classPathArray;
        ArrayList<URL> urlList = new ArrayList<URL>();
        String[] stringArray = classPathArray = System.getProperty("java.class.path").split(File.pathSeparator);
        int n = classPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            String classPath = stringArray[n2];
            if (this.configClassPathDirectory == null || !this.configClassPathDirectory.equals(classPath)) {
                File file;
                if (classPath.startsWith("./")) {
                    classPath = classPath.substring(2);
                }
                if ((file = new File(classPath)).exists()) {
                    try {
                        urlList.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++n2;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    protected void addConfigClassPath(List<URL> urlList) {
    }

    private void addConfigClassPathDirectory(String path, List<URL> urlList) {
        File file = new File(path = String.valueOf(path) + File.separator + "config");
        if (file.exists() && file.isDirectory()) {
            try {
                urlList.add(file.toURI().toURL());
                this.configClassPathDirectory = path;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

