/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.boot;

import cn.tom.hotswap.ClassLoaderKit;
import cn.tom.hotswap.HotSwapResolver;
import cn.tom.hotswap.HotSwapWatcher;
import cn.tom.kit.Helper;
import cn.tom.kit.io.Resource;
import cn.tom.mvc.handler.CocookServlet;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowLogger;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.FilterInfo;
import io.undertow.servlet.api.ListenerInfo;
import io.undertow.servlet.api.ServletInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;

public class UndertowServer {
    private ClassLoaderKit classLoaderKit;
    private HotSwapWatcher hotSwapWatcher;
    private ClassLoader clazzLoader;
    private int port = 80;
    private String host = "localhost";
    private String ctxpath = "/";
    private String rpath = "/";
    private DeploymentInfo deploymentInfo;
    private DeploymentManager deploymentManager;
    private Undertow server;
    private volatile boolean isStart;
    private String[] hotSwapPkg;

    public UndertowServer(Class<?> clazz, String ... hotSwapPkg) {
        this.hotSwapPkg = hotSwapPkg;
        this.clazzLoader = clazz.getClassLoader();
        HotSwapResolver resolver = new HotSwapResolver(UndertowServer.buildClassPathDirs());
        if (hotSwapPkg != null && hotSwapPkg.length > 0) {
            String[] stringArray = hotSwapPkg;
            int n = hotSwapPkg.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                resolver.addHotSwapClassPrefix(pkg);
                ++n2;
            }
        }
        this.classLoaderKit = new ClassLoaderKit(this.clazzLoader, resolver);
    }

    private static String[] buildClassPathDirs() {
        String[] classPathArray;
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = classPathArray = System.getProperty("java.class.path").split(File.pathSeparator);
        int n = classPathArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file;
            String classPath = stringArray[n2];
            if ((classPath = classPath.trim()).startsWith("./")) {
                classPath = classPath.substring(2);
            }
            if ((file = new File(classPath)).exists() && file.isDirectory()) {
                if (!classPath.endsWith(File.separator)) {
                    classPath = String.valueOf(classPath) + File.separator;
                }
                list.add(classPath);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public UndertowServer(DeploymentInfo deploymentInfo) {
        this.deploymentInfo = deploymentInfo;
    }

    public UndertowServer init(String[] args) {
        this.port = Helper.option(args, "-p", 80);
        this.ctxpath = Helper.option(args, "-ctxpath", "/");
        this.host = Helper.option(args, "-h", "127.0.0.1");
        this.rpath = Helper.option(args, "-rpath", "/");
        this.builder();
        return this;
    }

    public UndertowServer builder() {
        this.deploymentInfo = Servlets.deployment().setClassLoader(this.classLoaderKit.getClassLoader()).setContextPath(this.ctxpath).setDeploymentName("cocook-mvc");
        this.initWebRoot(this.rpath);
        return this;
    }

    public UndertowServer addInitParam(String name, String value) {
        this.deploymentInfo.addInitParameter(name, value);
        return this;
    }

    public UndertowServer initWebRoot(String path) {
        try {
            URL url = Resource.getDefaultClassLoader().getResource("");
            if (url == null) {
                return this;
            }
            File classpath = new File(url.getFile()).getParentFile();
            FileResourceManager resource = new FileResourceManager(new File(classpath.getCanonicalPath(), path), 0L);
            this.deploymentInfo.setResourceManager((ResourceManager)resource);
            UndertowLogger.ROOT_LOGGER.infof("init webroot rpath %s", (Object)resource.getBase());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public UndertowServer addServlet(Class<? extends Servlet> clazz, String mapping, int loadOnStartup) {
        ServletInfo servletInfo = Servlets.servlet(clazz).addMapping(mapping).setLoadOnStartup(Integer.valueOf(loadOnStartup));
        this.deploymentInfo.addServlets(new ServletInfo[]{servletInfo});
        return this;
    }

    public UndertowServer addServlet(ServletInfo servletInfo) {
        this.deploymentInfo.addServlet(servletInfo);
        return this;
    }

    public UndertowServer addlistener(ListenerInfo listenerInfo) {
        this.deploymentInfo.addListener(listenerInfo);
        return this;
    }

    public UndertowServer addCocookServlet() {
        ServletInfo servletInfo = Servlets.servlet(CocookServlet.class).addMapping("/").setLoadOnStartup(Integer.valueOf(1));
        this.deploymentInfo.addServlet(servletInfo);
        return this;
    }

    public UndertowServer addlistener(Class<? extends EventListener> clazz) {
        this.deploymentInfo.addListener(new ListenerInfo(clazz));
        return this;
    }

    public UndertowServer addFilter(FilterInfo filterInfo) {
        this.deploymentInfo.addFilter(filterInfo);
        return this;
    }

    public UndertowServer addFilter(Class<? extends Filter> filterClass) {
        this.deploymentInfo.addFilter(new FilterInfo(filterClass.getName(), filterClass));
        return this;
    }

    public void stop() {
        System.out.println("\nShutdown Undertow Server ......");
        long start = System.currentTimeMillis();
        try {
            try {
                if (this.hotSwapWatcher != null) {
                    this.hotSwapWatcher.exit();
                }
                this.deploymentManager.stop();
                this.deploymentManager.undeploy();
                this.server.stop();
                this.isStart = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.server != null) {
                    this.server.stop();
                }
                System.out.println("Shutdown Complete in " + (System.currentTimeMillis() - start) + " Millis. See you later (^_^)\n");
            }
        }
        finally {
            System.out.println("Shutdown Complete in " + (System.currentTimeMillis() - start) + " Millis. See you later (^_^)\n");
        }
    }

    public void start() throws ServletException {
        this.deploymentManager = Servlets.defaultContainer().addDeployment(this.deploymentInfo);
        this.deploymentManager.deploy();
        HttpHandler servletHandler = this.deploymentManager.start();
        PathHandler path = Handlers.path((HttpHandler)Handlers.redirect((String)this.ctxpath)).addPrefixPath(this.ctxpath, servletHandler);
        this.server = Undertow.builder().addHttpListener(this.port, this.host).setHandler((HttpHandler)path).build();
        this.server.start();
        UndertowLogger.ROOT_LOGGER.infof("Configuring listener with protocol %s for interface %s and port %s", (Object)"http", (Object)this.host, (Object)this.port);
        this.isStart = true;
        if (this.hotSwapPkg != null && this.hotSwapPkg.length > 0) {
            this.initHotSwapWatcher();
        }
    }

    void initHotSwapWatcher() {
        this.hotSwapWatcher = new HotSwapWatcher(this);
        this.hotSwapWatcher.start();
    }

    private void swapClassLoader() {
        this.deploymentInfo.setClassLoader(this.classLoaderKit.replaceClassLoader());
    }

    public void restart() {
        try {
            this.stop();
            this.swapClassLoader();
            this.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isStarted() {
        return this.isStart;
    }
}

