/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.view;

import cn.tom.mvc.config.Constants;
import cn.tom.mvc.core.CocookException;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.view.View;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class FreeMarkerView
extends View {
    private static final Configuration config = new Configuration();
    private static final String encoding = Constants.getEncoding();

    @Override
    public void init() {
        Properties properties = FreeMarkerView.config();
        if (properties != null) {
            try {
                config.setSettings(properties);
            }
            catch (TemplateException e) {
                throw new CocookException(e);
            }
            return;
        }
        try {
            config.setDirectoryForTemplateLoading(new File(Constants.getWebRoot()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        config.setTemplateUpdateDelay(0);
        config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        config.setObjectWrapper(ObjectWrapper.BEANS_WRAPPER);
        config.setDefaultEncoding(encoding);
        config.setOutputEncoding(encoding);
        config.setLocale(Locale.CHINA);
        config.setLocalizedLookup(false);
        config.setNumberFormat("#0.#####");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(String view) {
        RequestContext context = RequestContext.get();
        HttpServletResponse res = context.getResponse();
        res.setContentType("text/html;charset=" + encoding);
        res.setCharacterEncoding(encoding);
        try (PrintWriter writer = null;){
            Template template = config.getTemplate(view);
            ServletOutputStream output = res.getOutputStream();
            template.process(context.getAttributsMap(), (Writer)new OutputStreamWriter((OutputStream)output, encoding));
        }
    }

    private void error(HttpServletResponse response, Exception cause) throws IOException {
        StringBuffer html = new StringBuffer();
        html.append("<html>");
        html.append("<title>Error</title>");
        html.append("<body bgcolor=\"#ffffff\">");
        html.append("<h2>You know: Error processing the template</h2>");
        html.append("<xmp>");
        StringWriter sw = new StringWriter();
        cause.printStackTrace(new PrintWriter(sw));
        html.append(sw.toString());
        html.append("</xmp>");
        html.append("</body>");
        html.append("</html>");
        response.getOutputStream().print(html.toString());
    }
}

