/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.handler;

import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.mvc.annotation.Handler;
import cn.tom.mvc.annotation.HttpMethod;
import cn.tom.mvc.core.CocookException;
import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.ext.BeanFactory;
import cn.tom.mvc.handler.RequestMapping;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class HandlerInfo {
    private final ControllerModel controller;
    private final ConcurrentHashMap<RequestMapping, Method> methods = new ConcurrentHashMap();

    public HandlerInfo(ControllerModel controller, boolean isCoc) {
        this.controller = controller;
        if (isCoc) {
            return;
        }
        this.searchMethod(controller);
    }

    private ConcurrentHashMap<RequestMapping, Method> searchMethod(ControllerModel handler) {
        for (Class<?> clazz = handler.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] meths;
            for (Method me : meths = clazz.getDeclaredMethods()) {
                Handler.ExecMethod exec;
                Handler.Path path = me.getAnnotation(Handler.Path.class);
                if (path != null) {
                    for (HttpMethod hme : path.method()) {
                        RequestMapping maping = new RequestMapping(path.value(), hme);
                        this.methods.put(maping, me);
                    }
                }
                if ((exec = me.getAnnotation(Handler.ExecMethod.class)) == null) continue;
                this.paserFieldAnotation(handler);
                ReflectUtil.invokeMethod(me, handler);
            }
        }
        return this.methods;
    }

    public void paserFieldAnotation(ControllerModel handler) {
        Field[] fields;
        for (Field field : fields = handler.getClass().getDeclaredFields()) {
            Annotation[] anos = this.loadAnnotation(field);
            if (anos.length <= 0) continue;
            Handler.Resource resource = field.getAnnotation(Handler.Resource.class);
            field.setAccessible(true);
            if (resource == null) continue;
            try {
                field.set(handler, BeanFactory.getInstance(resource.value()));
            }
            catch (Exception e) {
                throw new CocookException(e);
            }
        }
    }

    private <T> Annotation[] loadAnnotation(T obj) {
        return ((AnnotatedElement)obj).getAnnotations();
    }

    public RequestMapping searchMechodByName(String name) {
        String key = this.controller.getClass().getSimpleName() + "." + name;
        RequestMapping mapping = new RequestMapping(key, null);
        if (this.methods.containsKey(mapping)) {
            return mapping;
        }
        Method me = ReflectUtil.findMethod(this.controller.getClass(), name);
        if (me != null) {
            this.methods.put(mapping, me);
        }
        return mapping;
    }

    public ControllerModel getController() {
        return this.controller;
    }

    public ConcurrentHashMap<RequestMapping, Method> getMethods() {
        return this.methods;
    }
}

