/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.handler;

import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.ext.BeanFactory;
import cn.tom.mvc.handler.Controller;
import cn.tom.mvc.handler.DefaultAnnotationHandler;
import cn.tom.mvc.handler.DefaultController;
import cn.tom.mvc.handler.Handler;
import cn.tom.mvc.handler.HandlerInfo;
import cn.tom.mvc.handler.RequestMapping;
import cn.tom.mvc.interceptor.Interceptor;
import cn.tom.mvc.interceptor.ProxyHandler;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNameHandler
implements Handler {
    private Logger logger = LoggerFactory.getLogger(DefaultNameHandler.class);
    private final HashMap<RequestMapping, HandlerInfo> apps = new HashMap();
    private final ArrayList<Interceptor> interceptors = new ArrayList();

    public HashMap<RequestMapping, HandlerInfo> getApps() {
        return this.apps;
    }

    public ArrayList<Interceptor> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public Controller proxyApp() {
        DefaultController handlerController = new DefaultController();
        if (this.interceptors.isEmpty()) {
            return handlerController;
        }
        ProxyHandler proxy = new ProxyHandler();
        return (Controller)proxy.bind(handlerController, this.interceptors);
    }

    @Override
    public void collectApps(String _pattern, ControllerModel _app) {
        HandlerInfo handlerInfo = new HandlerInfo(_app, true);
        Handler handler = (Handler)handlers.get(DefaultAnnotationHandler.class.getName());
        if (handler != null) {
            for (HandlerInfo handleriinfo : handler.getApps().values()) {
                if (handleriinfo.getController() != _app) continue;
                return;
            }
        }
        this.apps.put(new RequestMapping(_pattern, null), handlerInfo);
        this.logger.info("Mapped  URL path [" + _pattern + "] onto Controller " + _app.getClass().getSimpleName());
    }

    @Override
    public void collectInterceptor(Class<?> clazz) {
        Interceptor interceptor = (Interceptor)BeanFactory.newInstance(clazz);
        this.interceptors.add(interceptor);
        this.logger.info(clazz.getSimpleName() + " Binding onto " + this.getClass().getName());
    }

    @Override
    public HandlerInfo match(RequestMapping _mapping, RequestContext context) {
        String pattern = _mapping.getPath().substring(0, _mapping.getPath().lastIndexOf("/") + 1) + "*";
        RequestMapping mapping = new RequestMapping(pattern, null);
        HandlerInfo handlerInfo = this.apps.get(mapping);
        if (handlerInfo == null) {
            return null;
        }
        String methodName = matcher.extractPathWithinPattern(pattern, _mapping.getPath());
        mapping = handlerInfo.searchMechodByName(methodName);
        _mapping.setMethod(mapping.getMethod());
        _mapping.setPath(mapping.getPath());
        return handlerInfo;
    }

    public HandlerInfo match2(RequestMapping _mapping, RequestContext context) {
        for (RequestMapping mapping : this.apps.keySet()) {
            String pattern = mapping.getPath();
            if (!matcher.match(pattern, _mapping.getPath())) continue;
            HandlerInfo handlerInfo = this.apps.get(mapping);
            String methodName = matcher.extractPathWithinPattern(pattern, _mapping.getPath());
            mapping = handlerInfo.searchMechodByName(methodName);
            _mapping.setMethod(mapping.getMethod());
            _mapping.setPath(mapping.getPath());
            return handlerInfo;
        }
        return null;
    }
}

