/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.handler;

import cn.tom.db.jdbc.simple.DBUtil;
import cn.tom.db.mongo.MongoDao;
import cn.tom.kit.io.PropertiesUtil;
import cn.tom.kit.io.Resource;
import cn.tom.mvc.annotation.HttpMethod;
import cn.tom.mvc.config.Constants;
import cn.tom.mvc.core.CocookException;
import cn.tom.mvc.core.DefaultLogConfigure;
import cn.tom.mvc.core.Initializers;
import cn.tom.mvc.core.RequestContext;
import cn.tom.mvc.handler.Controller;
import cn.tom.mvc.handler.Handler;
import cn.tom.mvc.handler.HandlerInfo;
import cn.tom.mvc.handler.RequestMapping;
import cn.tom.mvc.interceptor.ActionInvocation;
import cn.tom.mvc.view.ViewFactory;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(name="CocookServlet", urlPatterns={"/"}, loadOnStartup=1)
public final class CocookServlet
extends HttpServlet {
    private static final long serialVersionUID = 2L;
    private static final String SystemConfigLocation = "SystemConfigLocation";

    private void initSystemConfig() throws IOException {
        String app = this.getInitParameter(SystemConfigLocation);
        if (app == null) {
            app = "app.properties";
        }
        Resource resource = new Resource(app);
        String webRoot = this.getServletContext().getRealPath("/");
        resource.setWebRoot(webRoot);
        Properties props = PropertiesUtil.loadProperties(resource);
        props.put("webRoot", resource.getPhysicalwebapp());
        Constants.getSyscfg().putAll(PropertiesUtil.toMap(props));
        System.out.println(Constants.getSyscfg());
    }

    private void initLog() {
        new DefaultLogConfigure().config();
    }

    private void initDataSource() throws IOException {
        if ("NONE".equals(Constants.getDBType())) {
            return;
        }
        Resource resource = new Resource(Constants.getDBConfigLocation());
        resource.setWebRoot(Constants.getWebRoot());
        Properties props = PropertiesUtil.loadProperties(resource);
        if ("SQL".equals(Constants.getDBType())) {
            DBUtil.init(props);
            return;
        }
        MongoDao.init(props);
    }

    private void initHandler() throws IOException, ClassNotFoundException {
        new Initializers().scan();
    }

    private void initView() {
        ViewFactory.initView();
    }

    public void init() throws ServletException {
        try {
            this.initSystemConfig();
            this.initLog();
            this.initDataSource();
            this.initHandler();
            this.initView();
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    public void destroy() {
        super.destroy();
        DBUtil.closeDataSource();
        System.out.println("servlet destroy........");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(RequestContext.begin(this.getServletContext(), req, res), HttpMethod.GET);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(RequestContext.begin(this.getServletContext(), req, res), HttpMethod.POST);
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.process(RequestContext.begin(this.getServletContext(), req, res), HttpMethod.OPTIONS);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(RequestContext requestContext, HttpMethod method) throws ServletException, IOException {
        try {
            this.matchHandler(requestContext, method);
        }
        finally {
            if (requestContext != null) {
                requestContext.end();
                requestContext = null;
            }
        }
    }

    private void matchHandler(RequestContext context, HttpMethod method) throws ServletException, IOException {
        String uri = context.getRequest().getRequestURI();
        String contextPath = context.getRequest().getContextPath();
        String queryAction = uri.substring(contextPath.length());
        RequestMapping mapping = new RequestMapping();
        mapping.setMethod(method);
        mapping.setPath(queryAction);
        try {
            this.execHandler(mapping, context, method);
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException ee) {
            throw ee;
        }
    }

    private void execHandler(RequestMapping mapping, RequestContext context, HttpMethod method) throws ServletException, IOException {
        for (Handler handler : Handler.handlers.values()) {
            HandlerInfo handlerInfo = handler.match(mapping, context);
            if (handlerInfo == null) continue;
            if (mapping.getMethod() != null && mapping.getMethod() != method) {
                context.error(403, mapping.toString());
                return;
            }
            Controller controller = handler.proxyApp();
            ActionInvocation actionInvocation = new ActionInvocation(handlerInfo, mapping);
            if (actionInvocation.getMethod() == null) continue;
            controller.enter(actionInvocation);
            controller = null;
            return;
        }
        String msg = mapping + " NOT FOUND ON " + this.getServletName();
        context.error(404, msg);
    }
}

