/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.ext;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;

public class JavassistUtil {
    public static String[] getMethodParamNames(Class<?> clazz, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        try {
            ClassPool pool = ClassPool.getDefault();
            pool.insertClassPath((ClassPath)new ClassClassPath(clazz));
            CtClass cc = pool.get(clazz.getName());
            String[] paramTypeNames = new String[method.getParameterTypes().length];
            for (int i = 0; i < paramTypes.length; ++i) {
                paramTypeNames[i] = paramTypes[i].getName();
            }
            CtMethod cm = cc.getDeclaredMethod(method.getName(), pool.get(paramTypeNames));
            MethodInfo methodInfo = cm.getMethodInfo();
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            if (attr == null) {
                throw new RuntimeException("class:" + clazz.getName() + ", have no LocalVariableTable, please use javac -g:{vars} to compile the source file");
            }
            int startIndex = JavassistUtil.getStartIndex(attr);
            String[] paramNames = new String[cm.getParameterTypes().length];
            int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
            for (int i = 0; i < paramNames.length; ++i) {
                paramNames[i] = attr.variableName(startIndex + i + pos);
            }
            return paramNames;
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    private static int getStartIndex(LocalVariableAttribute attr) {
        int startIndex = 0;
        for (int i = 0; i < attr.length(); ++i) {
            if (!"this".equals(attr.variableName(i))) continue;
            startIndex = i;
            break;
        }
        return startIndex;
    }
}

