/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.ext;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;

public class JavassistClassLoader
extends ClassLoader {
    private String rootDir;

    public JavassistClassLoader(String rootDir, ClassLoader parent) {
        super(parent);
        this.rootDir = rootDir;
    }

    public JavassistClassLoader(String rootDir) {
        this.rootDir = rootDir;
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        byte[] classData = null;
        try {
            classData = this.loadClassBytes(className);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Class<?> c = this.defineClass(className, classData, 0, classData.length);
        return c;
    }

    private byte[] loadClassBytes(String className) throws IOException {
        int i;
        String classFile = this.getClassFile(className);
        FileInputStream fis = new FileInputStream(classFile);
        FileChannel fileC = fis.getChannel();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        WritableByteChannel outC = Channels.newChannel(baos);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        while ((i = fileC.read(buffer)) != 0 && i != -1) {
            buffer.flip();
            outC.write(buffer);
            buffer.clear();
        }
        fis.close();
        return baos.toByteArray();
    }

    private String getClassFile(String name) {
        int len = name.length();
        char[] nameChars = new char[len];
        name.getChars(0, len, nameChars, 0);
        for (int i = 0; i < len; ++i) {
            if (nameChars[i] != '.') continue;
            nameChars[i] = File.separatorChar;
        }
        StringBuilder sb = new StringBuilder(this.rootDir);
        sb.append(File.separator).append(nameChars).append(".class");
        return sb.toString();
    }
}

