/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.ext;

import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.mvc.core.CocookException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;

public class ByteCodeFactory {
    public static Map<String, Object> BeanToMap(Object bean) {
        try {
            Class<?> clazz = ByteCodeFactory.createByBean(bean);
            Method m = clazz.getDeclaredMethod(bean.getClass().getSimpleName() + "$javassisttoMap", bean.getClass());
            return (Map)m.invoke(null, bean);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T mapToBean(Map<String, ?> map, Class<T> _class) {
        Class clazz = null;
        String methodName = _class.getSimpleName() + "$javassisttoBean";
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass("cn.tom.mvc.ext.JavassistUtil");
            Method me = clazz.getDeclaredMethod(methodName, Map.class, Object.class);
            return (T)me.invoke(null, map, _class.newInstance());
        }
        catch (Exception e) {
            try {
                clazz = ByteCodeFactory.createByMap(map, _class).toClass();
                Method me = clazz.getDeclaredMethod(methodName, Map.class, Object.class);
                return (T)me.invoke(null, map, _class.newInstance());
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }

    public static CtClass createByMap(Map<String, ?> map, Class<?> _class) throws Exception {
        ClassPool pool = ClassPool.getDefault();
        CtClass ctclass = pool.get("cn.tom.mvc.ext.JavassistUtil");
        CtMethod ctmethod = null;
        String methodName = _class.getSimpleName() + "$javassisttoBean";
        pool.importPackage("java.util");
        pool.importPackage("cn.tom.mvc.ext");
        ctmethod = new CtMethod(pool.get("java.lang.Object"), methodName, new CtClass[]{pool.get("java.util.Map"), pool.get("java.lang.Object")}, ctclass);
        ctmethod.setModifiers(8);
        StringBuffer buffer = new StringBuffer();
        buffer.append("{Map map = (Map)$1; \n");
        buffer.append(_class.getName() + " obj = (" + _class.getName() + ")$2; \n");
        Field[] fields = _class.getDeclaredFields();
        buffer.append("Object vv=null; String value=null; \n");
        for (Field f : fields) {
            String name = f.getName();
            Class<?> type = f.getType();
            buffer.append("vv = map.get(\"" + name + "\"); \n");
            buffer.append("if(vv!=null) {\n ");
            buffer.append("\tvalue = vv.toString(); \n");
            String setMethod = ReflectUtil.toSetMethod(name);
            String getMethod = ByteCodeFactory.getMethod(type);
            buffer.append("\tobj." + setMethod + "(" + getMethod + "); \n");
            buffer.append("}; \n");
        }
        buffer.append("return obj;}");
        ctmethod.setBody(buffer.toString());
        ctclass.addMethod(ctmethod);
        return ctclass;
    }

    public static String getMethod(Class<?> type) {
        String method = null;
        if (type == String.class) {
            method = "JavassistConverter.getStr(value)";
        } else if (type == Integer.class || type == Integer.TYPE) {
            method = "JavassistConverter.getInt(value)";
        } else if (type == Long.class || type == Long.TYPE) {
            method = "JavassistConverter.getLong(value)";
        } else if (type == Double.class || type == Double.TYPE) {
            method = "JavassistConverter.getDouble(value)";
        } else if (type == Float.class || type == Float.TYPE) {
            method = "JavassistConverter.getFloat(value)";
        } else if (type == Short.class || type == Short.TYPE) {
            method = "JavassistConverter.getShort(value)";
        } else if (type == Timestamp.class) {
            method = "JavassistConverter.getTime(value)";
        } else if (type == Date.class) {
            method = "JavassistConverter.getDate(value)";
        }
        if (method == null) {
            throw new CocookException("no type match to " + type);
        }
        return method;
    }

    public static Class<?> createByBean(Object bean) throws NotFoundException, CannotCompileException, IOException {
        ClassPool pool = ClassPool.getDefault();
        CtClass ctclass = pool.get("cn.tom.mvc.ext.JavassistUtil");
        String methodName = bean.getClass().getSimpleName() + "$javassisttoMap";
        CtMethod ctmethod = null;
        try {
            ctmethod = ctclass.getDeclaredMethod(methodName);
            return ctclass.toClass();
        }
        catch (Exception e) {
            ctmethod = CtNewMethod.make((String)("public static void " + methodName + "(){System.out.println(\"---------\");\t}"), (CtClass)ctclass);
            ctclass.addMethod(ctmethod);
            return ctclass.toClass();
        }
    }
}

