/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc.core;

import cn.tom.kit.StringUtil;
import cn.tom.mvc.annotation.Handler;
import cn.tom.mvc.config.Constants;
import cn.tom.mvc.core.CocookException;
import cn.tom.mvc.core.ControllerModel;
import cn.tom.mvc.ext.BeanFactory;
import cn.tom.mvc.ext.Scan;
import cn.tom.mvc.handler.DefaultAnnotationHandler;
import cn.tom.mvc.handler.DefaultNameHandler;
import cn.tom.mvc.handler.Handler;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Initializers {
    private Logger logger = LoggerFactory.getLogger(Initializers.class);
    private String scan_package = Constants.getScanPackage();
    private String handlers = Constants.getHandler();

    public Initializers() throws ClassNotFoundException {
        this.initHandler();
    }

    public void scan() throws IOException, ClassNotFoundException {
        for (String _package : this.scan_package.split(",")) {
            Set<Class<?>> set = Scan.scanpackage(_package);
            this.logger.info(_package + "::" + set);
            for (Class<?> clazz : set) {
                if (this.bindController(clazz) || this.bindInterceptor(clazz)) continue;
                this.bindInitialize(clazz);
            }
        }
    }

    private void initHandler() {
        for (String handler : this.handlers.split(",")) {
            Handler.handlers.put(handler, (Handler)BeanFactory.newInstance(handler));
        }
        if (Handler.handlers.size() == 0) {
            Handler.handlers.put("cn.tom.mvc.handler.DefaultAnnotationHandler", new DefaultAnnotationHandler());
        }
    }

    private boolean bindController(Class<?> clazz) {
        Handler.Controller controller = clazz.getAnnotation(Handler.Controller.class);
        if (controller == null) {
            return false;
        }
        String pattern = clazz.getSimpleName();
        if (pattern.indexOf("Controller") == -1) {
            throw new CocookException("Controller class must be endWith Controller");
        }
        pattern = StringUtil.substringBefore(pattern, "Controller").toLowerCase();
        ControllerModel app = (ControllerModel)BeanFactory.newInstance(clazz);
        for (Handler handler : Handler.handlers.values()) {
            if (handler instanceof DefaultAnnotationHandler) {
                handler.collectApps(null, app);
                continue;
            }
            if (!(handler instanceof DefaultNameHandler)) continue;
            handler.collectApps("/" + pattern + "/*", app);
        }
        return true;
    }

    private boolean bindInterceptor(Class<?> clazz) {
        Class<? extends Handler>[] interceptors;
        Handler.Interceptor interceptor = clazz.getAnnotation(Handler.Interceptor.class);
        if (interceptor == null) {
            return false;
        }
        for (Class<? extends Handler> Handlerclazz : interceptors = interceptor.value()) {
            Handler handler = Handler.handlers.get(Handlerclazz.getName());
            handler.collectInterceptor(clazz);
        }
        return true;
    }

    private void bindInitialize(Class<?> clazz) {
        Handler.Initialize initialize = clazz.getAnnotation(Handler.Initialize.class);
        if (initialize != null) {
            BeanFactory.newInstance(clazz);
        }
    }
}

