/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc;

import cn.tom.kit.Helper;
import cn.tom.mvc.TomcatResources;
import cn.tom.mvc.core.CocookException;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.tomcat.util.scan.StandardJarScanFilter;

public class TomcatStart {
    public static void run(Class<?> clazz, String[] args) {
        try {
            TomcatStart.tomcat_run(clazz, args);
        }
        catch (Exception e) {
            throw new CocookException(e);
        }
    }

    private static File getRootFolder(Class<?> clazz) {
        try {
            String runningJarPath = clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath().replaceAll("\\\\", "/");
            int lastIndexOf = runningJarPath.lastIndexOf("/target/");
            File root = lastIndexOf < 0 ? new File("") : new File(runningJarPath.substring(0, lastIndexOf));
            System.out.println("application resolved root folder: " + root.getAbsolutePath());
            return root;
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void tomcat_run(Class<?> clazz, String[] args) throws Exception {
        int port = Helper.option(args, "-p", 80);
        File root = TomcatStart.getRootFolder(clazz);
        System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
        Tomcat tomcat = new Tomcat();
        Path tempPath = Files.createTempDirectory("tomcat-base-dir", new FileAttribute[0]);
        tomcat.setBaseDir(tempPath.toString());
        tomcat.setPort(port);
        File webContentFolder = new File(root.getAbsolutePath(), "src/main/webapp/");
        if (!webContentFolder.exists()) {
            webContentFolder = Files.createTempDirectory("default-doc-base", new FileAttribute[0]).toFile();
        }
        StandardContext ctx = (StandardContext)tomcat.addWebapp("", webContentFolder.getAbsolutePath());
        ctx.setParentClassLoader(clazz.getClassLoader());
        if (System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip") == null && System.getProperty("tomcat.util.scan.StandardJarScanFilter.jarsToSkip") == null) {
            System.out.println("disabling TLD scanning");
            StandardJarScanFilter jarScanFilter = (StandardJarScanFilter)ctx.getJarScanner().getJarScanFilter();
            jarScanFilter.setTldSkip("*");
        }
        StandardRoot resources = new StandardRoot((Context)ctx);
        ctx.setResources((WebResourceRoot)resources);
        TomcatResources.get(resources.getContext()).addClasspathResources();
        tomcat.start();
        tomcat.getServer().await();
    }
}

