/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.mvc;

import cn.tom.kit.clazz.ReflectUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.JarResourceSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TomcatResources {
    Logger log = LoggerFactory.getLogger((String)"TomcatResources");
    private final Context context;

    TomcatResources(Context context) {
        this.context = context;
    }

    public void addClasspathResources() {
        ClassLoader loader = this.getClass().getClassLoader();
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                String dir;
                String file = url.getFile();
                if (file.endsWith(".jar") || file.endsWith(".jar!/")) {
                    String jar = url.toString();
                    this.addJar(jar);
                } else if (url.toString().startsWith("file:") && new File(dir = url.toString().substring("file:".length())).isDirectory()) {
                    this.addDir(dir, url);
                }
                this.log.info("Tomcat Embed Load Resource :: " + url.toString());
            }
        }
    }

    protected final Context getContext() {
        return this.context;
    }

    protected abstract void addJar(String var1);

    protected abstract void addDir(String var1, URL var2);

    public static TomcatResources get(Context context) {
        try {
            Class.forName("org.apache.catalina.deploy.ErrorPage");
            return new Tomcat7Resources(context);
        }
        catch (Exception e) {
            return new Tomcat8Resources(context);
        }
    }

    static class Tomcat8Resources
    extends TomcatResources {
        Tomcat8Resources(Context context) {
            super(context);
        }

        @Override
        protected void addJar(String jar) {
            try {
                if (jar.indexOf("cocook") == -1) {
                    return;
                }
                URL url = new URL(jar);
                JarResourceSet resourceSet = new JarResourceSet(this.getContext().getResources(), "/WEB-INF/classes", url.getPath(), "/");
                this.getContext().getResources().addPreResources((WebResourceSet)resourceSet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        protected void addDir(String dir, URL url) {
            this.addResourceSet(url.toString());
        }

        private void addResourceSet(String resource) {
            try {
                URL url = new URL(resource);
                DirResourceSet resourceSet = new DirResourceSet(this.getContext().getResources(), "/WEB-INF/classes", url.getPath(), "/");
                this.getContext().getResources().addPreResources((WebResourceSet)resourceSet);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class Tomcat7Resources
    extends TomcatResources {
        private final Method addResourceJarUrlMethod;

        Tomcat7Resources(Context context) {
            super(context);
            this.addResourceJarUrlMethod = ReflectUtil.findMethod(context.getClass(), "addResourceJarUrl", URL.class);
        }

        @Override
        protected void addJar(String jar) {
            URL url = this.getJarUrl(jar);
            if (url != null) {
                try {
                    this.addResourceJarUrlMethod.invoke((Object)this.getContext(), url);
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }

        private URL getJarUrl(String jar) {
            try {
                return new URL(jar);
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }

        @Override
        protected void addDir(String dir, URL url) {
            if (this.getContext() instanceof ServletContext) {
                try {
                    Class<?> fileDirContextClass = Class.forName("org.apache.naming.resources.FileDirContext");
                    Method setDocBaseMethod = ReflectUtil.findMethod(fileDirContextClass, "setDocBase", String.class);
                    Object fileDirContext = fileDirContextClass.newInstance();
                    setDocBaseMethod.invoke(fileDirContext, dir);
                    Method addResourcesDirContextMethod = ReflectUtil.findMethod(StandardContext.class, "addResourcesDirContext", DirContext.class);
                    addResourcesDirContextMethod.invoke((Object)this.getContext(), fileDirContext);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Tomcat 7 reflection failed", ex);
                }
            }
        }
    }
}

