/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit.io;

import cn.tom.mvc.core.CocookException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.commons.lang.RandomStringUtils;

public class FileUtil {
    public static String readLine(File _file, String encode) {
        StringBuffer buff = new StringBuffer();
        String s = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(_file), encode));
            while ((s = reader.readLine()) != null) {
                buff.append(s);
            }
        }
        catch (IOException e) {
            throw new CocookException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                reader = null;
            }
        }
        return buff.toString();
    }

    public static String streamToStr(InputStream in, String encode) {
        StringBuffer buff = new StringBuffer();
        String s = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, encode));
            while ((s = reader.readLine()) != null) {
                buff.append(s);
            }
        }
        catch (IOException e) {
            throw new CocookException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                reader = null;
            }
        }
        return buff.toString();
    }

    public static InputStream strToStream(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    public static InputStream ToInStream(ByteArrayOutputStream out) {
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static void copyFolder(String source, String target) {
        String[] fNames;
        new File(target).mkdirs();
        File fsource = new File(source);
        for (String name : fNames = fsource.list()) {
            File temp = new File(source + "/" + name);
            if (temp.isFile()) {
                try {
                    FileUtil.copy(new FileInputStream(temp), new FileOutputStream(target + "/" + name));
                }
                catch (FileNotFoundException e) {}
                continue;
            }
            FileUtil.copyFolder(source + "/" + name, target + "/" + name);
        }
    }

    public static void deleteDirectory(String ObjectPath) {
        File[] files;
        File file = new File(ObjectPath);
        for (File f : files = file.listFiles()) {
            if (f.isFile()) {
                f.delete();
                continue;
            }
            FileUtil.deleteDirectory(ObjectPath + "/" + f.getName());
            f.delete();
        }
    }

    public static void copy(InputStream in, OutputStream out) {
        BufferedInputStream _in = null;
        BufferedOutputStream _out = null;
        try {
            _in = new BufferedInputStream(in);
            _out = new BufferedOutputStream(out);
            byte[] b = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)_in).read(b, 0, b.length)) != -1) {
                ((OutputStream)_out).write(b, 0, len);
            }
            ((OutputStream)_out).flush();
        }
        catch (IOException e) {
            try {
                throw new CocookException(e);
            }
            catch (Throwable throwable) {
                FileUtil.close(_in, _out);
                throw throwable;
            }
        }
        FileUtil.close(_in, _out);
    }

    public static void transfer(FileInputStream in, FileOutputStream out) throws IOException {
        FileChannel source = null;
        FileChannel target = null;
        try {
            source = in.getChannel();
            target = out.getChannel();
            long size = source.size();
            source.transferTo(0L, size, target);
        }
        catch (IOException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                FileUtil.close(source, target);
                throw throwable;
            }
        }
        FileUtil.close(source, target);
    }

    public static void copyFile(File source, File target) throws IOException {
        FileChannel inChannel = new FileInputStream(source).getChannel();
        FileChannel outChannel = new FileOutputStream(target).getChannel();
        ByteBuffer bb = ByteBuffer.allocate(1024);
        try {
            while (inChannel.read(bb) != -1) {
                bb.flip();
                outChannel.write(bb);
                bb.clear();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            FileUtil.close(inChannel, outChannel);
        }
    }

    public static void close(InputStream in, OutputStream out) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                in = null;
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                in = null;
            }
        }
    }

    public static void close(FileChannel source, FileChannel target) {
        if (source != null) {
            try {
                source.close();
            }
            catch (IOException e) {
                source = null;
            }
        }
        if (target != null) {
            try {
                target.close();
            }
            catch (IOException e) {
                target = null;
            }
        }
    }

    public static String randomstr(int size) {
        return RandomStringUtils.randomAlphanumeric((int)size);
    }
}

