/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit.clazz;

import cn.tom.kit.clazz.BridgeMethodResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.WeakHashMap;

public class AnnotationUtils {
    static final String VALUE = "value";
    private static final Map<Class, Boolean> annotatedInterfaceCache = new WeakHashMap<Class, Boolean>();

    public static <A extends Annotation> A findAnnotation(Class<?> clazz, Class<A> annotationType) {
        Class<?> superClass;
        A annotation = clazz.getAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        for (Class<?> ifc : clazz.getInterfaces()) {
            annotation = AnnotationUtils.findAnnotation(ifc, annotationType);
            if (annotation == null) continue;
            return annotation;
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            for (Annotation ann : clazz.getAnnotations()) {
                annotation = AnnotationUtils.findAnnotation(ann.annotationType(), annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        if ((superClass = clazz.getSuperclass()) == null || superClass == Object.class) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superClass, annotationType);
    }

    public static <A extends Annotation> A findAnnotation(Method method, Class<A> annotationType) {
        A annotation = AnnotationUtils.getAnnotation(method, annotationType);
        Class<?> cl = method.getDeclaringClass();
        if (annotation == null) {
            annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
        }
        while (annotation == null && (cl = cl.getSuperclass()) != null && cl != Object.class) {
            try {
                Method equivalentMethod = cl.getDeclaredMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
                if (annotation != null) continue;
                annotation = AnnotationUtils.searchOnInterfaces(method, annotationType, cl.getInterfaces());
            }
            catch (NoSuchMethodException ex) {}
        }
        return annotation;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Method resolvedMethod = BridgeMethodResolver.findBridgedMethod(method);
        A ann = resolvedMethod.getAnnotation(annotationType);
        if (ann == null) {
            Annotation metaAnn;
            Annotation[] arr$ = resolvedMethod.getAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (ann = (metaAnn = arr$[i$]).annotationType().getAnnotation(annotationType)) == null; ++i$) {
            }
        }
        return ann;
    }

    private static <A extends Annotation> A searchOnInterfaces(Method method, Class<A> annotationType, Class[] ifcs) {
        A annotation = null;
        for (Class iface : ifcs) {
            if (!AnnotationUtils.isInterfaceWithAnnotatedMethods(iface)) continue;
            try {
                Method equivalentMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                annotation = AnnotationUtils.getAnnotation(equivalentMethod, annotationType);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (annotation != null) break;
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterfaceWithAnnotatedMethods(Class<?> iface) {
        Map<Class, Boolean> map = annotatedInterfaceCache;
        synchronized (map) {
            Boolean flag = annotatedInterfaceCache.get(iface);
            if (flag != null) {
                return flag;
            }
            boolean found = false;
            for (Method ifcMethod : iface.getMethods()) {
                if (ifcMethod.getAnnotations().length <= 0) continue;
                found = true;
                break;
            }
            annotatedInterfaceCache.put(iface, found);
            return found;
        }
    }

    public static Object getValue(Annotation annotation, String attributeName) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            return method.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Object getValue(Annotation annotation) {
        return AnnotationUtils.getValue(annotation, VALUE);
    }
}

