/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class StringUtil {
    public static final String EMPTY = "";
    public static final int INDEX_NOT_FOUND = -1;

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean equals(String str1, String str2) {
        return str1 == null ? false : str1.equals(str2);
    }

    public static String escapeSql(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("'", "''");
    }

    public static String substringBefore(String str, String separator) {
        if (StringUtil.isEmpty(str) || separator == null) {
            return str;
        }
        if (separator.length() == 0) {
            return EMPTY;
        }
        int pos = str.indexOf(separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBetween(String str, String tag) {
        return StringUtil.substringBetween(str, tag, tag);
    }

    public static String substringBetween(String str, String open, String close) {
        int end;
        if (str == null || open == null || close == null) {
            return null;
        }
        int start = str.indexOf(open);
        if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
            return str.substring(start + open.length(), end);
        }
        return null;
    }

    public static boolean contains(String str, String searchStr) {
        if (str == null || searchStr == null) {
            return false;
        }
        return str.indexOf(searchStr) >= 0;
    }

    public static String defaultIfEmpty(String str, String defaultStr) {
        return StringUtil.isEmpty(str) ? defaultStr : str;
    }

    public static String join(Object[] obj, String split) {
        StringBuffer str = new StringBuffer();
        for (Object o : obj) {
            if (o == null || o.toString().isEmpty()) continue;
            if (str.length() > 0) {
                str.append(split);
            }
            str.append(o);
        }
        return str.toString();
    }

    public static String[] tokenizeToStringArray(String str, String delimiters) {
        return StringUtil.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringUtil.toStringArray(tokens);
    }

    public static String[] toStringArray(Collection<String> collection) {
        if (collection == null) {
            return null;
        }
        return collection.toArray(new String[collection.size()]);
    }

    public static boolean hasText(String str) {
        return StringUtil.hasText((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!StringUtil.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static int countOccurrencesOf(String str, String sub) {
        int idx;
        if (str == null || sub == null || str.length() == 0 || sub.length() == 0) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((idx = str.indexOf(sub, pos)) != -1) {
            ++count;
            pos = idx + sub.length();
        }
        return count;
    }

    public static String composeMessage(String source, String ... replacement) {
        if (replacement.length == 0) {
            return source;
        }
        for (int i = 0; i < replacement.length; ++i) {
            int start = source.indexOf("{");
            if (start < 0) {
                return source;
            }
            int end = source.indexOf("}") + 1;
            String pattern = source.substring(start, end);
            source = replacement[i] == null ? source.replace(pattern, EMPTY) : source.replace(pattern, replacement[i]);
        }
        return source;
    }
}

