/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.kit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageOutputStream;

public class RandomNumImage {
    private ByteArrayInputStream image;
    private String str;

    private RandomNumImage() {
        this.init();
    }

    public static RandomNumImage getInstance() {
        return new RandomNumImage();
    }

    public ByteArrayInputStream getImage() {
        return this.image;
    }

    public String getString() {
        return this.str;
    }

    private void init() {
        int width = 75;
        int height = 24;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        Random random = new Random();
        g.setColor(this.getRandColor(200, 250));
        g.fillRect(0, 0, width, height);
        g.setFont(new Font("Times New Roman", 0, 22));
        g.setColor(this.getRandColor(160, 200));
        for (int i = 0; i < 100; ++i) {
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int xl = random.nextInt(12);
            int yl = random.nextInt(12);
            g.drawLine(x, y, x + xl, y + yl);
        }
        String ranStr = "ABCDEFGHJKLmnPQRStuvwxyz23456789";
        String ranNum = "";
        for (int i = 0; i < 4; ++i) {
            String ran = ranStr.charAt(random.nextInt(ranStr.length())) + "";
            ranNum = ranNum + ran;
            g.setColor(new Color(20 + random.nextInt(100), 20 + random.nextInt(100), 20 + random.nextInt(110)));
            g.drawString(ran, 13 * i + 12, 20);
        }
        this.str = ranNum;
        g.dispose();
        ByteArrayInputStream input = null;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ImageOutputStream imageOut = ImageIO.createImageOutputStream(output);
            ImageIO.write((RenderedImage)image, "JPEG", imageOut);
            imageOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.image = input = new ByteArrayInputStream(output.toByteArray());
    }

    private Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

