/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.redis;

import cn.tom.db.redis.RedisDao;
import cn.tom.mvc.ext.BeanFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class RedisUtil {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    RedisDao redisDao = BeanFactory.getInstance(RedisDao.class);
    private static RedisUtil self;

    public static RedisUtil getInstance() {
        if (self == null) {
            self = new RedisUtil();
        }
        return self;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Jedis jedis = null;
        String value = null;
        try {
            jedis = this.redisDao.getResource();
            value = jedis.get(key);
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("get", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            String string = jedis.set(key, value);
            return string;
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("set", (Throwable)e);
            String string = "0";
            return string;
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String key, String value, int seconds) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            String string = jedis.setex(key, seconds, value);
            return string;
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("set", (Throwable)e);
            String string = "0";
            return string;
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(String ... keys) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            Long l = jedis.del(keys);
            return l;
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("del", (Throwable)e);
            Long l = 0L;
            return l;
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String key) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            boolean bl = jedis.exists(key);
            return bl;
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("exists", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDB() {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            jedis.flushDB();
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("flushDB", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sethash(String key, Map<String, String> hash) {
        Jedis jedis = null;
        String res = null;
        try {
            jedis = this.redisDao.getResource();
            res = jedis.hmset(key, hash);
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("sethash", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sethash(String key, Map<String, String> hash, int seconds) {
        Jedis jedis = null;
        String res = null;
        try {
            jedis = this.redisDao.getResource();
            res = jedis.hmset(key, hash);
            jedis.expire(key, seconds);
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("sethash", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> gethash(String key) {
        Jedis jedis = null;
        Map res = null;
        try {
            jedis = this.redisDao.getResource();
            res = jedis.hgetAll(key);
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("gethash", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String ... values) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            jedis.lpush(key, values);
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("gethash", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, int seconds, String ... values) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            jedis.lpush(key, values);
            jedis.expire(key, seconds);
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("gethash", (Throwable)e);
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getlist(String key) {
        Jedis jedis = null;
        try {
            jedis = this.redisDao.getResource();
            List list = jedis.lrange(key, 0L, jedis.hlen(key).longValue());
            return list;
        }
        catch (Exception e) {
            this.redisDao.returnBrokenResource(jedis);
            this.log.error("gethash", (Throwable)e);
            List<String> list = Collections.emptyList();
            return list;
        }
        finally {
            this.redisDao.returnResource(jedis);
        }
    }
}

