/*
 * Decompiled with CFR 0.152.
 */
package cn.tom.db.redis;

import cn.tom.kit.clazz.ReflectUtil;
import cn.tom.kit.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisDao {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private JedisPool pool = null;
    JedisPoolConfig config = new JedisPoolConfig();
    private int port = 6379;
    private String host = "127.0.0.1";
    private String password;
    private int maxActive = 200;
    private int maxIdle = 10;
    private int maxWait;
    private boolean testOnBorrow;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public JedisPoolConfig getConfig() {
        return this.config;
    }

    public void setConfig(JedisPoolConfig config) {
        this.config = config;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public void init() {
        this.config.setMaxActive(this.maxActive);
        this.config.setMaxIdle(this.maxIdle);
        this.config.setMaxWait((long)this.maxWait);
        this.config.setTestOnBorrow(this.testOnBorrow);
        this.pool = new JedisPool((GenericObjectPool.Config)this.config, this.host, this.port, 100000);
        this.log.info("init Redis success::" + this.pool + " :" + this.host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(File file) {
        Properties pro = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            pro.load(in);
            ReflectUtil.populate(this, pro);
        }
        catch (IOException e) {
            this.log.info("read MongoDbconfig error", (Throwable)e);
        }
        finally {
            FileUtil.close(in, null);
        }
        this.init();
    }

    public void init(Properties pro) {
        ReflectUtil.populate(this, pro);
        this.init();
    }

    public void cleanUp() {
        this.pool.destroy();
    }

    public Jedis getResource() {
        Jedis jedis = (Jedis)this.pool.getResource();
        if (this.password != null) {
            jedis.auth(this.password);
        }
        return jedis;
    }

    public void returnResource(Jedis jedis) {
        this.pool.returnResource((Object)jedis);
    }

    public void returnBrokenResource(Jedis jedis) {
        this.pool.returnBrokenResource((Object)jedis);
    }
}

